package io.fabric8.knative.internal.autoscaling.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodAutoscalerBuilder extends PodAutoscalerFluent<PodAutoscalerBuilder> implements VisitableBuilder<PodAutoscaler,PodAutoscalerBuilder>{
  public PodAutoscalerBuilder() {
    this(false);
  }
  public PodAutoscalerBuilder(Boolean validationEnabled) {
    this(new PodAutoscaler(), validationEnabled);
  }
  public PodAutoscalerBuilder(PodAutoscalerFluent<?> fluent) {
    this(fluent, false);
  }
  public PodAutoscalerBuilder(PodAutoscalerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodAutoscaler(), validationEnabled);
  }
  public PodAutoscalerBuilder(PodAutoscalerFluent<?> fluent,PodAutoscaler instance) {
    this(fluent, instance, false);
  }
  public PodAutoscalerBuilder(PodAutoscalerFluent<?> fluent,PodAutoscaler instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodAutoscaler());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodAutoscalerBuilder(PodAutoscaler instance) {
    this(instance,false);
  }
  public PodAutoscalerBuilder(PodAutoscaler instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodAutoscaler());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodAutoscalerFluent<?> fluent;
  Boolean validationEnabled;
  public PodAutoscaler build() {
    PodAutoscaler buildable = new PodAutoscaler(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}