package io.fabric8.knative.internal.autoscaling.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodAutoscalerListBuilder extends PodAutoscalerListFluent<PodAutoscalerListBuilder> implements VisitableBuilder<PodAutoscalerList,PodAutoscalerListBuilder>{
  public PodAutoscalerListBuilder() {
    this(false);
  }
  public PodAutoscalerListBuilder(Boolean validationEnabled) {
    this(new PodAutoscalerList(), validationEnabled);
  }
  public PodAutoscalerListBuilder(PodAutoscalerListFluent<?> fluent) {
    this(fluent, false);
  }
  public PodAutoscalerListBuilder(PodAutoscalerListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodAutoscalerList(), validationEnabled);
  }
  public PodAutoscalerListBuilder(PodAutoscalerListFluent<?> fluent,PodAutoscalerList instance) {
    this(fluent, instance, false);
  }
  public PodAutoscalerListBuilder(PodAutoscalerListFluent<?> fluent,PodAutoscalerList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodAutoscalerList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodAutoscalerListBuilder(PodAutoscalerList instance) {
    this(instance,false);
  }
  public PodAutoscalerListBuilder(PodAutoscalerList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodAutoscalerList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodAutoscalerListFluent<?> fluent;
  Boolean validationEnabled;
  public PodAutoscalerList build() {
    PodAutoscalerList buildable = new PodAutoscalerList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}