package io.fabric8.knative.internal.autoscaling.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodAutoscalerStatusBuilder extends PodAutoscalerStatusFluent<PodAutoscalerStatusBuilder> implements VisitableBuilder<PodAutoscalerStatus,PodAutoscalerStatusBuilder>{
  public PodAutoscalerStatusBuilder() {
    this(false);
  }
  public PodAutoscalerStatusBuilder(Boolean validationEnabled) {
    this(new PodAutoscalerStatus(), validationEnabled);
  }
  public PodAutoscalerStatusBuilder(PodAutoscalerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public PodAutoscalerStatusBuilder(PodAutoscalerStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodAutoscalerStatus(), validationEnabled);
  }
  public PodAutoscalerStatusBuilder(PodAutoscalerStatusFluent<?> fluent,PodAutoscalerStatus instance) {
    this(fluent, instance, false);
  }
  public PodAutoscalerStatusBuilder(PodAutoscalerStatusFluent<?> fluent,PodAutoscalerStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodAutoscalerStatus());

    if (instance != null) {
      fluent.withActualScale(instance.getActualScale());
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withConditions(instance.getConditions());
      fluent.withDesiredScale(instance.getDesiredScale());
      fluent.withMetricsServiceName(instance.getMetricsServiceName());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withServiceName(instance.getServiceName());
      fluent.withActualScale(instance.getActualScale());
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withConditions(instance.getConditions());
      fluent.withDesiredScale(instance.getDesiredScale());
      fluent.withMetricsServiceName(instance.getMetricsServiceName());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withServiceName(instance.getServiceName());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodAutoscalerStatusBuilder(PodAutoscalerStatus instance) {
    this(instance,false);
  }
  public PodAutoscalerStatusBuilder(PodAutoscalerStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodAutoscalerStatus());

    if (instance != null) {
      this.withActualScale(instance.getActualScale());
      this.withAnnotations(instance.getAnnotations());
      this.withConditions(instance.getConditions());
      this.withDesiredScale(instance.getDesiredScale());
      this.withMetricsServiceName(instance.getMetricsServiceName());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withServiceName(instance.getServiceName());
      this.withActualScale(instance.getActualScale());
      this.withAnnotations(instance.getAnnotations());
      this.withConditions(instance.getConditions());
      this.withDesiredScale(instance.getDesiredScale());
      this.withMetricsServiceName(instance.getMetricsServiceName());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withServiceName(instance.getServiceName());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodAutoscalerStatusFluent<?> fluent;
  Boolean validationEnabled;
  public PodAutoscalerStatus build() {
    PodAutoscalerStatus buildable = new PodAutoscalerStatus(fluent.getActualScale(),fluent.getAnnotations(),fluent.buildConditions(),fluent.getDesiredScale(),fluent.getMetricsServiceName(),fluent.getObservedGeneration(),fluent.getServiceName());
    return buildable;
  }
  
}