package io.fabric8.knative.internal.caching.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageStatusBuilder extends ImageStatusFluent<ImageStatusBuilder> implements VisitableBuilder<ImageStatus,ImageStatusBuilder>{
  public ImageStatusBuilder() {
    this(false);
  }
  public ImageStatusBuilder(Boolean validationEnabled) {
    this(new ImageStatus(), validationEnabled);
  }
  public ImageStatusBuilder(ImageStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageStatusBuilder(ImageStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageStatus(), validationEnabled);
  }
  public ImageStatusBuilder(ImageStatusFluent<?> fluent,ImageStatus instance) {
    this(fluent, instance, false);
  }
  public ImageStatusBuilder(ImageStatusFluent<?> fluent,ImageStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ImageStatus());

    if (instance != null) {
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImageStatusBuilder(ImageStatus instance) {
    this(instance,false);
  }
  public ImageStatusBuilder(ImageStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ImageStatus());

    if (instance != null) {
      this.withAnnotations(instance.getAnnotations());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withAnnotations(instance.getAnnotations());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImageStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ImageStatus build() {
    ImageStatus buildable = new ImageStatus(fluent.getAnnotations(),fluent.buildConditions(),fluent.getObservedGeneration());
    return buildable;
  }
  
}