package io.fabric8.knative.internal.eventing.pkg.apis.duck.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SubscriberStatusBuilder extends SubscriberStatusFluent<SubscriberStatusBuilder> implements VisitableBuilder<SubscriberStatus,SubscriberStatusBuilder>{
  public SubscriberStatusBuilder() {
    this(false);
  }
  public SubscriberStatusBuilder(Boolean validationEnabled) {
    this(new SubscriberStatus(), validationEnabled);
  }
  public SubscriberStatusBuilder(SubscriberStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public SubscriberStatusBuilder(SubscriberStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SubscriberStatus(), validationEnabled);
  }
  public SubscriberStatusBuilder(SubscriberStatusFluent<?> fluent,SubscriberStatus instance) {
    this(fluent, instance, false);
  }
  public SubscriberStatusBuilder(SubscriberStatusFluent<?> fluent,SubscriberStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SubscriberStatus());

    if (instance != null) {
      fluent.withMessage(instance.getMessage());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withReady(instance.getReady());
      fluent.withUid(instance.getUid());
      fluent.withMessage(instance.getMessage());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withReady(instance.getReady());
      fluent.withUid(instance.getUid());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SubscriberStatusBuilder(SubscriberStatus instance) {
    this(instance,false);
  }
  public SubscriberStatusBuilder(SubscriberStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SubscriberStatus());

    if (instance != null) {
      this.withMessage(instance.getMessage());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withReady(instance.getReady());
      this.withUid(instance.getUid());
      this.withMessage(instance.getMessage());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withReady(instance.getReady());
      this.withUid(instance.getUid());
    }
    this.validationEnabled = validationEnabled; 
  }
  SubscriberStatusFluent<?> fluent;
  Boolean validationEnabled;
  public SubscriberStatus build() {
    SubscriberStatus buildable = new SubscriberStatus(fluent.getMessage(),fluent.getObservedGeneration(),fluent.getReady(),fluent.getUid());
    return buildable;
  }
  
}