package io.fabric8.knative.internal.eventing.pkg.apis.duck.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PlacementBuilder extends PlacementFluent<PlacementBuilder> implements VisitableBuilder<Placement,PlacementBuilder>{
  public PlacementBuilder() {
    this(false);
  }
  public PlacementBuilder(Boolean validationEnabled) {
    this(new Placement(), validationEnabled);
  }
  public PlacementBuilder(PlacementFluent<?> fluent) {
    this(fluent, false);
  }
  public PlacementBuilder(PlacementFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Placement(), validationEnabled);
  }
  public PlacementBuilder(PlacementFluent<?> fluent,Placement instance) {
    this(fluent, instance, false);
  }
  public PlacementBuilder(PlacementFluent<?> fluent,Placement instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Placement());

    if (instance != null) {
      fluent.withPodName(instance.getPodName());
      fluent.withVreplicas(instance.getVreplicas());
      fluent.withPodName(instance.getPodName());
      fluent.withVreplicas(instance.getVreplicas());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PlacementBuilder(Placement instance) {
    this(instance,false);
  }
  public PlacementBuilder(Placement instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Placement());

    if (instance != null) {
      this.withPodName(instance.getPodName());
      this.withVreplicas(instance.getVreplicas());
      this.withPodName(instance.getPodName());
      this.withVreplicas(instance.getVreplicas());
    }
    this.validationEnabled = validationEnabled; 
  }
  PlacementFluent<?> fluent;
  Boolean validationEnabled;
  public Placement build() {
    Placement buildable = new Placement(fluent.getPodName(),fluent.getVreplicas());
    return buildable;
  }
  
}