package io.fabric8.knative.internal.networking.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CertificateBuilder extends CertificateFluent<CertificateBuilder> implements VisitableBuilder<Certificate,CertificateBuilder>{
  public CertificateBuilder() {
    this(false);
  }
  public CertificateBuilder(Boolean validationEnabled) {
    this(new Certificate(), validationEnabled);
  }
  public CertificateBuilder(CertificateFluent<?> fluent) {
    this(fluent, false);
  }
  public CertificateBuilder(CertificateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Certificate(), validationEnabled);
  }
  public CertificateBuilder(CertificateFluent<?> fluent,Certificate instance) {
    this(fluent, instance, false);
  }
  public CertificateBuilder(CertificateFluent<?> fluent,Certificate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Certificate());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CertificateBuilder(Certificate instance) {
    this(instance,false);
  }
  public CertificateBuilder(Certificate instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Certificate());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  CertificateFluent<?> fluent;
  Boolean validationEnabled;
  public Certificate build() {
    Certificate buildable = new Certificate(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}