package io.fabric8.knative.internal.networking.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CertificateSpecBuilder extends CertificateSpecFluent<CertificateSpecBuilder> implements VisitableBuilder<CertificateSpec,CertificateSpecBuilder>{
  public CertificateSpecBuilder() {
    this(false);
  }
  public CertificateSpecBuilder(Boolean validationEnabled) {
    this(new CertificateSpec(), validationEnabled);
  }
  public CertificateSpecBuilder(CertificateSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public CertificateSpecBuilder(CertificateSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CertificateSpec(), validationEnabled);
  }
  public CertificateSpecBuilder(CertificateSpecFluent<?> fluent,CertificateSpec instance) {
    this(fluent, instance, false);
  }
  public CertificateSpecBuilder(CertificateSpecFluent<?> fluent,CertificateSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CertificateSpec());

    if (instance != null) {
      fluent.withDnsNames(instance.getDnsNames());
      fluent.withDomain(instance.getDomain());
      fluent.withSecretName(instance.getSecretName());
      fluent.withDnsNames(instance.getDnsNames());
      fluent.withDomain(instance.getDomain());
      fluent.withSecretName(instance.getSecretName());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CertificateSpecBuilder(CertificateSpec instance) {
    this(instance,false);
  }
  public CertificateSpecBuilder(CertificateSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CertificateSpec());

    if (instance != null) {
      this.withDnsNames(instance.getDnsNames());
      this.withDomain(instance.getDomain());
      this.withSecretName(instance.getSecretName());
      this.withDnsNames(instance.getDnsNames());
      this.withDomain(instance.getDomain());
      this.withSecretName(instance.getSecretName());
    }
    this.validationEnabled = validationEnabled; 
  }
  CertificateSpecFluent<?> fluent;
  Boolean validationEnabled;
  public CertificateSpec build() {
    CertificateSpec buildable = new CertificateSpec(fluent.getDnsNames(),fluent.getDomain(),fluent.getSecretName());
    return buildable;
  }
  
}