package io.fabric8.knative.internal.networking.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.function.Predicate;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CertificateSpecFluent<A extends CertificateSpecFluent<A>> extends BaseFluent<A>{
  public CertificateSpecFluent() {
  }
  public CertificateSpecFluent(CertificateSpec instance) {
    instance = (instance != null ? instance : new CertificateSpec());

    if (instance != null) {
      this.withDnsNames(instance.getDnsNames());
      this.withDomain(instance.getDomain());
      this.withSecretName(instance.getSecretName());
      this.withDnsNames(instance.getDnsNames());
      this.withDomain(instance.getDomain());
      this.withSecretName(instance.getSecretName());
    }
  }
  private List<String> dnsNames = new ArrayList<String>();
  private String domain;
  private String secretName;
  public A addToDnsNames(int index,String item) {
    if (this.dnsNames == null) {this.dnsNames = new ArrayList<String>();}
    this.dnsNames.add(index, item);
    return (A)this;
  }
  public A setToDnsNames(int index,String item) {
    if (this.dnsNames == null) {this.dnsNames = new ArrayList<String>();}
    this.dnsNames.set(index, item); return (A)this;
  }
  public A addToDnsNames(java.lang.String... items) {
    if (this.dnsNames == null) {this.dnsNames = new ArrayList<String>();}
    for (String item : items) {this.dnsNames.add(item);} return (A)this;
  }
  public A addAllToDnsNames(Collection<String> items) {
    if (this.dnsNames == null) {this.dnsNames = new ArrayList<String>();}
    for (String item : items) {this.dnsNames.add(item);} return (A)this;
  }
  public A removeFromDnsNames(java.lang.String... items) {
    if (this.dnsNames == null) return (A)this;
    for (String item : items) { this.dnsNames.remove(item);} return (A)this;
  }
  public A removeAllFromDnsNames(Collection<String> items) {
    if (this.dnsNames == null) return (A)this;
    for (String item : items) { this.dnsNames.remove(item);} return (A)this;
  }
  public List<String> getDnsNames() {
    return this.dnsNames;
  }
  public String getDnsName(int index) {
    return this.dnsNames.get(index);
  }
  public String getFirstDnsName() {
    return this.dnsNames.get(0);
  }
  public String getLastDnsName() {
    return this.dnsNames.get(dnsNames.size() - 1);
  }
  public String getMatchingDnsName(Predicate<String> predicate) {
    for (String item: dnsNames) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingDnsName(Predicate<String> predicate) {
    for (String item: dnsNames) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDnsNames(List<String> dnsNames) {
    if (dnsNames != null) {this.dnsNames = new ArrayList(); for (String item : dnsNames){this.addToDnsNames(item);}} else { this.dnsNames = null;} return (A) this;
  }
  public A withDnsNames(java.lang.String... dnsNames) {
    if (this.dnsNames != null) {this.dnsNames.clear(); _visitables.remove("dnsNames"); }
    if (dnsNames != null) {for (String item :dnsNames){ this.addToDnsNames(item);}} return (A) this;
  }
  public boolean hasDnsNames() {
    return dnsNames != null && !dnsNames.isEmpty();
  }
  public String getDomain() {
    return this.domain;
  }
  public A withDomain(String domain) {
    this.domain=domain; return (A) this;
  }
  public boolean hasDomain() {
    return this.domain != null;
  }
  public String getSecretName() {
    return this.secretName;
  }
  public A withSecretName(String secretName) {
    this.secretName=secretName; return (A) this;
  }
  public boolean hasSecretName() {
    return this.secretName != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CertificateSpecFluent that = (CertificateSpecFluent) o;
    if (!java.util.Objects.equals(dnsNames, that.dnsNames)) return false;

    if (!java.util.Objects.equals(domain, that.domain)) return false;

    if (!java.util.Objects.equals(secretName, that.secretName)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(dnsNames,  domain,  secretName,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (dnsNames != null && !dnsNames.isEmpty()) { sb.append("dnsNames:"); sb.append(dnsNames + ","); }
    if (domain != null) { sb.append("domain:"); sb.append(domain + ","); }
    if (secretName != null) { sb.append("secretName:"); sb.append(secretName); }
    sb.append("}");
    return sb.toString();
  }
  
}