package io.fabric8.knative.internal.networking.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CertificateStatusBuilder extends CertificateStatusFluent<CertificateStatusBuilder> implements VisitableBuilder<CertificateStatus,CertificateStatusBuilder>{
  public CertificateStatusBuilder() {
    this(false);
  }
  public CertificateStatusBuilder(Boolean validationEnabled) {
    this(new CertificateStatus(), validationEnabled);
  }
  public CertificateStatusBuilder(CertificateStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public CertificateStatusBuilder(CertificateStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CertificateStatus(), validationEnabled);
  }
  public CertificateStatusBuilder(CertificateStatusFluent<?> fluent,CertificateStatus instance) {
    this(fluent, instance, false);
  }
  public CertificateStatusBuilder(CertificateStatusFluent<?> fluent,CertificateStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CertificateStatus());

    if (instance != null) {
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withConditions(instance.getConditions());
      fluent.withHttp01Challenges(instance.getHttp01Challenges());
      fluent.withNotAfter(instance.getNotAfter());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withConditions(instance.getConditions());
      fluent.withHttp01Challenges(instance.getHttp01Challenges());
      fluent.withNotAfter(instance.getNotAfter());
      fluent.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CertificateStatusBuilder(CertificateStatus instance) {
    this(instance,false);
  }
  public CertificateStatusBuilder(CertificateStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CertificateStatus());

    if (instance != null) {
      this.withAnnotations(instance.getAnnotations());
      this.withConditions(instance.getConditions());
      this.withHttp01Challenges(instance.getHttp01Challenges());
      this.withNotAfter(instance.getNotAfter());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withAnnotations(instance.getAnnotations());
      this.withConditions(instance.getConditions());
      this.withHttp01Challenges(instance.getHttp01Challenges());
      this.withNotAfter(instance.getNotAfter());
      this.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  CertificateStatusFluent<?> fluent;
  Boolean validationEnabled;
  public CertificateStatus build() {
    CertificateStatus buildable = new CertificateStatus(fluent.getAnnotations(),fluent.buildConditions(),fluent.buildHttp01Challenges(),fluent.getNotAfter(),fluent.getObservedGeneration());
    return buildable;
  }
  
}