package io.fabric8.knative.internal.networking.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTP01ChallengeBuilder extends HTTP01ChallengeFluent<HTTP01ChallengeBuilder> implements VisitableBuilder<HTTP01Challenge,HTTP01ChallengeBuilder>{
  public HTTP01ChallengeBuilder() {
    this(false);
  }
  public HTTP01ChallengeBuilder(Boolean validationEnabled) {
    this(new HTTP01Challenge(), validationEnabled);
  }
  public HTTP01ChallengeBuilder(HTTP01ChallengeFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTP01ChallengeBuilder(HTTP01ChallengeFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTP01Challenge(), validationEnabled);
  }
  public HTTP01ChallengeBuilder(HTTP01ChallengeFluent<?> fluent,HTTP01Challenge instance) {
    this(fluent, instance, false);
  }
  public HTTP01ChallengeBuilder(HTTP01ChallengeFluent<?> fluent,HTTP01Challenge instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new HTTP01Challenge());

    if (instance != null) {
      fluent.withServiceName(instance.getServiceName());
      fluent.withServiceNamespace(instance.getServiceNamespace());
      fluent.withServicePort(instance.getServicePort());
      fluent.withUrl(instance.getUrl());
      fluent.withServiceName(instance.getServiceName());
      fluent.withServiceNamespace(instance.getServiceNamespace());
      fluent.withServicePort(instance.getServicePort());
      fluent.withUrl(instance.getUrl());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HTTP01ChallengeBuilder(HTTP01Challenge instance) {
    this(instance,false);
  }
  public HTTP01ChallengeBuilder(HTTP01Challenge instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new HTTP01Challenge());

    if (instance != null) {
      this.withServiceName(instance.getServiceName());
      this.withServiceNamespace(instance.getServiceNamespace());
      this.withServicePort(instance.getServicePort());
      this.withUrl(instance.getUrl());
      this.withServiceName(instance.getServiceName());
      this.withServiceNamespace(instance.getServiceNamespace());
      this.withServicePort(instance.getServicePort());
      this.withUrl(instance.getUrl());
    }
    this.validationEnabled = validationEnabled; 
  }
  HTTP01ChallengeFluent<?> fluent;
  Boolean validationEnabled;
  public HTTP01Challenge build() {
    HTTP01Challenge buildable = new HTTP01Challenge(fluent.getServiceName(),fluent.getServiceNamespace(),fluent.buildServicePort(),fluent.getUrl());
    return buildable;
  }
  
}