package io.fabric8.knative.internal.networking.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressSpecBuilder extends IngressSpecFluent<IngressSpecBuilder> implements VisitableBuilder<IngressSpec,IngressSpecBuilder>{
  public IngressSpecBuilder() {
    this(false);
  }
  public IngressSpecBuilder(Boolean validationEnabled) {
    this(new IngressSpec(), validationEnabled);
  }
  public IngressSpecBuilder(IngressSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressSpecBuilder(IngressSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IngressSpec(), validationEnabled);
  }
  public IngressSpecBuilder(IngressSpecFluent<?> fluent,IngressSpec instance) {
    this(fluent, instance, false);
  }
  public IngressSpecBuilder(IngressSpecFluent<?> fluent,IngressSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new IngressSpec());

    if (instance != null) {
      fluent.withHttpOption(instance.getHttpOption());
      fluent.withRules(instance.getRules());
      fluent.withTls(instance.getTls());
      fluent.withHttpOption(instance.getHttpOption());
      fluent.withRules(instance.getRules());
      fluent.withTls(instance.getTls());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IngressSpecBuilder(IngressSpec instance) {
    this(instance,false);
  }
  public IngressSpecBuilder(IngressSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new IngressSpec());

    if (instance != null) {
      this.withHttpOption(instance.getHttpOption());
      this.withRules(instance.getRules());
      this.withTls(instance.getTls());
      this.withHttpOption(instance.getHttpOption());
      this.withRules(instance.getRules());
      this.withTls(instance.getTls());
    }
    this.validationEnabled = validationEnabled; 
  }
  IngressSpecFluent<?> fluent;
  Boolean validationEnabled;
  public IngressSpec build() {
    IngressSpec buildable = new IngressSpec(fluent.getHttpOption(),fluent.buildRules(),fluent.buildTls());
    return buildable;
  }
  
}