package io.fabric8.knative.internal.networking.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServerlessServiceStatusBuilder extends ServerlessServiceStatusFluent<ServerlessServiceStatusBuilder> implements VisitableBuilder<ServerlessServiceStatus,ServerlessServiceStatusBuilder>{
  public ServerlessServiceStatusBuilder() {
    this(false);
  }
  public ServerlessServiceStatusBuilder(Boolean validationEnabled) {
    this(new ServerlessServiceStatus(), validationEnabled);
  }
  public ServerlessServiceStatusBuilder(ServerlessServiceStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ServerlessServiceStatusBuilder(ServerlessServiceStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServerlessServiceStatus(), validationEnabled);
  }
  public ServerlessServiceStatusBuilder(ServerlessServiceStatusFluent<?> fluent,ServerlessServiceStatus instance) {
    this(fluent, instance, false);
  }
  public ServerlessServiceStatusBuilder(ServerlessServiceStatusFluent<?> fluent,ServerlessServiceStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ServerlessServiceStatus());

    if (instance != null) {
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withPrivateServiceName(instance.getPrivateServiceName());
      fluent.withServiceName(instance.getServiceName());
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withPrivateServiceName(instance.getPrivateServiceName());
      fluent.withServiceName(instance.getServiceName());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServerlessServiceStatusBuilder(ServerlessServiceStatus instance) {
    this(instance,false);
  }
  public ServerlessServiceStatusBuilder(ServerlessServiceStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ServerlessServiceStatus());

    if (instance != null) {
      this.withAnnotations(instance.getAnnotations());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withPrivateServiceName(instance.getPrivateServiceName());
      this.withServiceName(instance.getServiceName());
      this.withAnnotations(instance.getAnnotations());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withPrivateServiceName(instance.getPrivateServiceName());
      this.withServiceName(instance.getServiceName());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServerlessServiceStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ServerlessServiceStatus build() {
    ServerlessServiceStatus buildable = new ServerlessServiceStatus(fluent.getAnnotations(),fluent.buildConditions(),fluent.getObservedGeneration(),fluent.getPrivateServiceName(),fluent.getServiceName());
    return buildable;
  }
  
}