package io.fabric8.knative.internal.pkg.apis;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConditionBuilder extends ConditionFluent<ConditionBuilder> implements VisitableBuilder<Condition,ConditionBuilder>{
  public ConditionBuilder() {
    this(false);
  }
  public ConditionBuilder(Boolean validationEnabled) {
    this(new Condition(), validationEnabled);
  }
  public ConditionBuilder(ConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public ConditionBuilder(ConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Condition(), validationEnabled);
  }
  public ConditionBuilder(ConditionFluent<?> fluent,Condition instance) {
    this(fluent, instance, false);
  }
  public ConditionBuilder(ConditionFluent<?> fluent,Condition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Condition());

    if (instance != null) {
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withSeverity(instance.getSeverity());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withSeverity(instance.getSeverity());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConditionBuilder(Condition instance) {
    this(instance,false);
  }
  public ConditionBuilder(Condition instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Condition());

    if (instance != null) {
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withSeverity(instance.getSeverity());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withSeverity(instance.getSeverity());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConditionFluent<?> fluent;
  Boolean validationEnabled;
  public Condition build() {
    Condition buildable = new Condition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getSeverity(),fluent.getStatus(),fluent.getType());
    return buildable;
  }
  
}