package io.fabric8.knative.internal.pkg.apis.duck.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CloudEventOverridesBuilder extends CloudEventOverridesFluent<CloudEventOverridesBuilder> implements VisitableBuilder<CloudEventOverrides,CloudEventOverridesBuilder>{
  public CloudEventOverridesBuilder() {
    this(false);
  }
  public CloudEventOverridesBuilder(Boolean validationEnabled) {
    this(new CloudEventOverrides(), validationEnabled);
  }
  public CloudEventOverridesBuilder(CloudEventOverridesFluent<?> fluent) {
    this(fluent, false);
  }
  public CloudEventOverridesBuilder(CloudEventOverridesFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CloudEventOverrides(), validationEnabled);
  }
  public CloudEventOverridesBuilder(CloudEventOverridesFluent<?> fluent,CloudEventOverrides instance) {
    this(fluent, instance, false);
  }
  public CloudEventOverridesBuilder(CloudEventOverridesFluent<?> fluent,CloudEventOverrides instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CloudEventOverrides());

    if (instance != null) {
      fluent.withExtensions(instance.getExtensions());
      fluent.withExtensions(instance.getExtensions());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CloudEventOverridesBuilder(CloudEventOverrides instance) {
    this(instance,false);
  }
  public CloudEventOverridesBuilder(CloudEventOverrides instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CloudEventOverrides());

    if (instance != null) {
      this.withExtensions(instance.getExtensions());
      this.withExtensions(instance.getExtensions());
    }
    this.validationEnabled = validationEnabled; 
  }
  CloudEventOverridesFluent<?> fluent;
  Boolean validationEnabled;
  public CloudEventOverrides build() {
    CloudEventOverrides buildable = new CloudEventOverrides(fluent.getExtensions());
    return buildable;
  }
  
}