package io.fabric8.knative.internal.pkg.apis.duck.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KResourceBuilder extends KResourceFluent<KResourceBuilder> implements VisitableBuilder<KResource,KResourceBuilder>{
  public KResourceBuilder() {
    this(false);
  }
  public KResourceBuilder(Boolean validationEnabled) {
    this(new KResource(), validationEnabled);
  }
  public KResourceBuilder(KResourceFluent<?> fluent) {
    this(fluent, false);
  }
  public KResourceBuilder(KResourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KResource(), validationEnabled);
  }
  public KResourceBuilder(KResourceFluent<?> fluent,KResource instance) {
    this(fluent, instance, false);
  }
  public KResourceBuilder(KResourceFluent<?> fluent,KResource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KResource());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KResourceBuilder(KResource instance) {
    this(instance,false);
  }
  public KResourceBuilder(KResource instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KResource());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  KResourceFluent<?> fluent;
  Boolean validationEnabled;
  public KResource build() {
    KResource buildable = new KResource(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildStatus());
    return buildable;
  }
  
}