package io.fabric8.knative.internal.pkg.apis.duck.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SourceListBuilder extends SourceListFluent<SourceListBuilder> implements VisitableBuilder<SourceList,SourceListBuilder>{
  public SourceListBuilder() {
    this(false);
  }
  public SourceListBuilder(Boolean validationEnabled) {
    this(new SourceList(), validationEnabled);
  }
  public SourceListBuilder(SourceListFluent<?> fluent) {
    this(fluent, false);
  }
  public SourceListBuilder(SourceListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SourceList(), validationEnabled);
  }
  public SourceListBuilder(SourceListFluent<?> fluent,SourceList instance) {
    this(fluent, instance, false);
  }
  public SourceListBuilder(SourceListFluent<?> fluent,SourceList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SourceList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SourceListBuilder(SourceList instance) {
    this(instance,false);
  }
  public SourceListBuilder(SourceList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SourceList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  SourceListFluent<?> fluent;
  Boolean validationEnabled;
  public SourceList build() {
    SourceList buildable = new SourceList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}