package io.fabric8.knative.internal.pkg.apis.duck.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SourceSpecBuilder extends SourceSpecFluent<SourceSpecBuilder> implements VisitableBuilder<SourceSpec,SourceSpecBuilder>{
  public SourceSpecBuilder() {
    this(false);
  }
  public SourceSpecBuilder(Boolean validationEnabled) {
    this(new SourceSpec(), validationEnabled);
  }
  public SourceSpecBuilder(SourceSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public SourceSpecBuilder(SourceSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SourceSpec(), validationEnabled);
  }
  public SourceSpecBuilder(SourceSpecFluent<?> fluent,SourceSpec instance) {
    this(fluent, instance, false);
  }
  public SourceSpecBuilder(SourceSpecFluent<?> fluent,SourceSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SourceSpec());

    if (instance != null) {
      fluent.withCeOverrides(instance.getCeOverrides());
      fluent.withSink(instance.getSink());
      fluent.withCeOverrides(instance.getCeOverrides());
      fluent.withSink(instance.getSink());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SourceSpecBuilder(SourceSpec instance) {
    this(instance,false);
  }
  public SourceSpecBuilder(SourceSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SourceSpec());

    if (instance != null) {
      this.withCeOverrides(instance.getCeOverrides());
      this.withSink(instance.getSink());
      this.withCeOverrides(instance.getCeOverrides());
      this.withSink(instance.getSink());
    }
    this.validationEnabled = validationEnabled; 
  }
  SourceSpecFluent<?> fluent;
  Boolean validationEnabled;
  public SourceSpec build() {
    SourceSpec buildable = new SourceSpec(fluent.buildCeOverrides(),fluent.buildSink());
    return buildable;
  }
  
}