package io.fabric8.knative.internal.pkg.apis.duck.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class WithPodSpecBuilder extends WithPodSpecFluent<WithPodSpecBuilder> implements VisitableBuilder<WithPodSpec,WithPodSpecBuilder>{
  public WithPodSpecBuilder() {
    this(false);
  }
  public WithPodSpecBuilder(Boolean validationEnabled) {
    this(new WithPodSpec(), validationEnabled);
  }
  public WithPodSpecBuilder(WithPodSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public WithPodSpecBuilder(WithPodSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new WithPodSpec(), validationEnabled);
  }
  public WithPodSpecBuilder(WithPodSpecFluent<?> fluent,WithPodSpec instance) {
    this(fluent, instance, false);
  }
  public WithPodSpecBuilder(WithPodSpecFluent<?> fluent,WithPodSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new WithPodSpec());

    if (instance != null) {
      fluent.withTemplate(instance.getTemplate());
      fluent.withTemplate(instance.getTemplate());
    }
    this.validationEnabled = validationEnabled; 
  }
  public WithPodSpecBuilder(WithPodSpec instance) {
    this(instance,false);
  }
  public WithPodSpecBuilder(WithPodSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new WithPodSpec());

    if (instance != null) {
      this.withTemplate(instance.getTemplate());
      this.withTemplate(instance.getTemplate());
    }
    this.validationEnabled = validationEnabled; 
  }
  WithPodSpecFluent<?> fluent;
  Boolean validationEnabled;
  public WithPodSpec build() {
    WithPodSpec buildable = new WithPodSpec(fluent.buildTemplate());
    return buildable;
  }
  
}