package io.fabric8.knative.internal.pkg.apis.duck.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BindingSpecBuilder extends BindingSpecFluent<BindingSpecBuilder> implements VisitableBuilder<BindingSpec,BindingSpecBuilder>{
  public BindingSpecBuilder() {
    this(false);
  }
  public BindingSpecBuilder(Boolean validationEnabled) {
    this(new BindingSpec(), validationEnabled);
  }
  public BindingSpecBuilder(BindingSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public BindingSpecBuilder(BindingSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BindingSpec(), validationEnabled);
  }
  public BindingSpecBuilder(BindingSpecFluent<?> fluent,BindingSpec instance) {
    this(fluent, instance, false);
  }
  public BindingSpecBuilder(BindingSpecFluent<?> fluent,BindingSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new BindingSpec());

    if (instance != null) {
      fluent.withSubject(instance.getSubject());
      fluent.withSubject(instance.getSubject());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BindingSpecBuilder(BindingSpec instance) {
    this(instance,false);
  }
  public BindingSpecBuilder(BindingSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new BindingSpec());

    if (instance != null) {
      this.withSubject(instance.getSubject());
      this.withSubject(instance.getSubject());
    }
    this.validationEnabled = validationEnabled; 
  }
  BindingSpecFluent<?> fluent;
  Boolean validationEnabled;
  public BindingSpec build() {
    BindingSpec buildable = new BindingSpec(fluent.buildSubject());
    return buildable;
  }
  
}