package io.fabric8.knative.internal.pkg.apis.duck.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TargetBuilder extends TargetFluent<TargetBuilder> implements VisitableBuilder<Target,TargetBuilder>{
  public TargetBuilder() {
    this(false);
  }
  public TargetBuilder(Boolean validationEnabled) {
    this(new Target(), validationEnabled);
  }
  public TargetBuilder(TargetFluent<?> fluent) {
    this(fluent, false);
  }
  public TargetBuilder(TargetFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Target(), validationEnabled);
  }
  public TargetBuilder(TargetFluent<?> fluent,Target instance) {
    this(fluent, instance, false);
  }
  public TargetBuilder(TargetFluent<?> fluent,Target instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Target());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TargetBuilder(Target instance) {
    this(instance,false);
  }
  public TargetBuilder(Target instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Target());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  TargetFluent<?> fluent;
  Boolean validationEnabled;
  public Target build() {
    Target buildable = new Target(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildStatus());
    return buildable;
  }
  
}