package io.fabric8.knative.internal.pkg.apis.duck.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TargetStatusBuilder extends TargetStatusFluent<TargetStatusBuilder> implements VisitableBuilder<TargetStatus,TargetStatusBuilder>{
  public TargetStatusBuilder() {
    this(false);
  }
  public TargetStatusBuilder(Boolean validationEnabled) {
    this(new TargetStatus(), validationEnabled);
  }
  public TargetStatusBuilder(TargetStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public TargetStatusBuilder(TargetStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TargetStatus(), validationEnabled);
  }
  public TargetStatusBuilder(TargetStatusFluent<?> fluent,TargetStatus instance) {
    this(fluent, instance, false);
  }
  public TargetStatusBuilder(TargetStatusFluent<?> fluent,TargetStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new TargetStatus());

    if (instance != null) {
      fluent.withTargetable(instance.getTargetable());
      fluent.withTargetable(instance.getTargetable());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TargetStatusBuilder(TargetStatus instance) {
    this(instance,false);
  }
  public TargetStatusBuilder(TargetStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new TargetStatus());

    if (instance != null) {
      this.withTargetable(instance.getTargetable());
      this.withTargetable(instance.getTargetable());
    }
    this.validationEnabled = validationEnabled; 
  }
  TargetStatusFluent<?> fluent;
  Boolean validationEnabled;
  public TargetStatus build() {
    TargetStatus buildable = new TargetStatus(fluent.buildTargetable());
    return buildable;
  }
  
}