package io.fabric8.knative.internal.pkg.apis.duck.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AddressableBuilder extends AddressableFluent<AddressableBuilder> implements VisitableBuilder<Addressable,AddressableBuilder>{
  public AddressableBuilder() {
    this(false);
  }
  public AddressableBuilder(Boolean validationEnabled) {
    this(new Addressable(), validationEnabled);
  }
  public AddressableBuilder(AddressableFluent<?> fluent) {
    this(fluent, false);
  }
  public AddressableBuilder(AddressableFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Addressable(), validationEnabled);
  }
  public AddressableBuilder(AddressableFluent<?> fluent,Addressable instance) {
    this(fluent, instance, false);
  }
  public AddressableBuilder(AddressableFluent<?> fluent,Addressable instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Addressable());

    if (instance != null) {
      fluent.withCACerts(instance.getCACerts());
      fluent.withName(instance.getName());
      fluent.withUrl(instance.getUrl());
      fluent.withCACerts(instance.getCACerts());
      fluent.withName(instance.getName());
      fluent.withUrl(instance.getUrl());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AddressableBuilder(Addressable instance) {
    this(instance,false);
  }
  public AddressableBuilder(Addressable instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Addressable());

    if (instance != null) {
      this.withCACerts(instance.getCACerts());
      this.withName(instance.getName());
      this.withUrl(instance.getUrl());
      this.withCACerts(instance.getCACerts());
      this.withName(instance.getName());
      this.withUrl(instance.getUrl());
    }
    this.validationEnabled = validationEnabled; 
  }
  AddressableFluent<?> fluent;
  Boolean validationEnabled;
  public Addressable build() {
    Addressable buildable = new Addressable(fluent.getCACerts(),fluent.getName(),fluent.getUrl());
    return buildable;
  }
  
}