package io.fabric8.knative.internal.pkg.apis.duck.v1beta1;

import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Object;
import java.lang.String;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class DestinationFluent<A extends DestinationFluent<A>> extends BaseFluent<A>{
  public DestinationFluent() {
  }
  public DestinationFluent(Destination instance) {
    instance = (instance != null ? instance : new Destination());

    if (instance != null) {
      this.withCACerts(instance.getCACerts());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withRef(instance.getRef());
      this.withUri(instance.getUri());
      this.withCACerts(instance.getCACerts());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withRef(instance.getRef());
      this.withUri(instance.getUri());
    }
  }
  private String cACerts;
  private String apiVersion;
  private String kind;
  private String name;
  private String namespace;
  private ObjectReferenceBuilder ref;
  private String uri;
  public String getCACerts() {
    return this.cACerts;
  }
  public A withCACerts(String cACerts) {
    this.cACerts=cACerts; return (A) this;
  }
  public boolean hasCACerts() {
    return this.cACerts != null;
  }
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public boolean hasKind() {
    return this.kind != null;
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public boolean hasName() {
    return this.name != null;
  }
  public String getNamespace() {
    return this.namespace;
  }
  public A withNamespace(String namespace) {
    this.namespace=namespace; return (A) this;
  }
  public boolean hasNamespace() {
    return this.namespace != null;
  }
  public ObjectReference buildRef() {
    return this.ref!=null ?this.ref.build():null;
  }
  public A withRef(ObjectReference ref) {
    _visitables.get("ref").remove(this.ref);
    if (ref!=null){ this.ref= new ObjectReferenceBuilder(ref); _visitables.get("ref").add(this.ref);} else { this.ref = null; _visitables.get("ref").remove(this.ref); } return (A) this;
  }
  public boolean hasRef() {
    return this.ref != null;
  }
  public RefNested<A> withNewRef() {
    return new RefNested(null);
  }
  public RefNested<A> withNewRefLike(ObjectReference item) {
    return new RefNested(item);
  }
  public RefNested<A> editRef() {
    return withNewRefLike(java.util.Optional.ofNullable(buildRef()).orElse(null));
  }
  public RefNested<A> editOrNewRef() {
    return withNewRefLike(java.util.Optional.ofNullable(buildRef()).orElse(new ObjectReferenceBuilder().build()));
  }
  public RefNested<A> editOrNewRefLike(ObjectReference item) {
    return withNewRefLike(java.util.Optional.ofNullable(buildRef()).orElse(item));
  }
  public String getUri() {
    return this.uri;
  }
  public A withUri(String uri) {
    this.uri=uri; return (A) this;
  }
  public boolean hasUri() {
    return this.uri != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DestinationFluent that = (DestinationFluent) o;
    if (!java.util.Objects.equals(cACerts, that.cACerts)) return false;

    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(name, that.name)) return false;

    if (!java.util.Objects.equals(namespace, that.namespace)) return false;

    if (!java.util.Objects.equals(ref, that.ref)) return false;

    if (!java.util.Objects.equals(uri, that.uri)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(cACerts,  apiVersion,  kind,  name,  namespace,  ref,  uri,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (cACerts != null) { sb.append("cACerts:"); sb.append(cACerts + ","); }
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (namespace != null) { sb.append("namespace:"); sb.append(namespace + ","); }
    if (ref != null) { sb.append("ref:"); sb.append(ref + ","); }
    if (uri != null) { sb.append("uri:"); sb.append(uri); }
    sb.append("}");
    return sb.toString();
  }
  public class RefNested<N> extends ObjectReferenceFluent<RefNested<N>> implements Nested<N>{
    RefNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) DestinationFluent.this.withRef(builder.build());
    }
    public N endRef() {
      return and();
    }
    
  }
  
}