package io.fabric8.knative.internal.pkg.apis.duck.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SourceStatusBuilder extends SourceStatusFluent<SourceStatusBuilder> implements VisitableBuilder<SourceStatus,SourceStatusBuilder>{
  public SourceStatusBuilder() {
    this(false);
  }
  public SourceStatusBuilder(Boolean validationEnabled) {
    this(new SourceStatus(), validationEnabled);
  }
  public SourceStatusBuilder(SourceStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public SourceStatusBuilder(SourceStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SourceStatus(), validationEnabled);
  }
  public SourceStatusBuilder(SourceStatusFluent<?> fluent,SourceStatus instance) {
    this(fluent, instance, false);
  }
  public SourceStatusBuilder(SourceStatusFluent<?> fluent,SourceStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SourceStatus());

    if (instance != null) {
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withSinkUri(instance.getSinkUri());
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withSinkUri(instance.getSinkUri());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SourceStatusBuilder(SourceStatus instance) {
    this(instance,false);
  }
  public SourceStatusBuilder(SourceStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SourceStatus());

    if (instance != null) {
      this.withAnnotations(instance.getAnnotations());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withSinkUri(instance.getSinkUri());
      this.withAnnotations(instance.getAnnotations());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withSinkUri(instance.getSinkUri());
    }
    this.validationEnabled = validationEnabled; 
  }
  SourceStatusFluent<?> fluent;
  Boolean validationEnabled;
  public SourceStatus build() {
    SourceStatus buildable = new SourceStatus(fluent.getAnnotations(),fluent.buildConditions(),fluent.getObservedGeneration(),fluent.getSinkUri());
    return buildable;
  }
  
}