package io.fabric8.knative.messaging.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ChannelListBuilder extends ChannelListFluent<ChannelListBuilder> implements VisitableBuilder<ChannelList,ChannelListBuilder>{
  public ChannelListBuilder() {
    this(false);
  }
  public ChannelListBuilder(Boolean validationEnabled) {
    this(new ChannelList(), validationEnabled);
  }
  public ChannelListBuilder(ChannelListFluent<?> fluent) {
    this(fluent, false);
  }
  public ChannelListBuilder(ChannelListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ChannelList(), validationEnabled);
  }
  public ChannelListBuilder(ChannelListFluent<?> fluent,ChannelList instance) {
    this(fluent, instance, false);
  }
  public ChannelListBuilder(ChannelListFluent<?> fluent,ChannelList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ChannelList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ChannelListBuilder(ChannelList instance) {
    this(instance,false);
  }
  public ChannelListBuilder(ChannelList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ChannelList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  ChannelListFluent<?> fluent;
  Boolean validationEnabled;
  public ChannelList build() {
    ChannelList buildable = new ChannelList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}