package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RevisionStatusBuilder extends RevisionStatusFluent<RevisionStatusBuilder> implements VisitableBuilder<RevisionStatus,RevisionStatusBuilder>{
  public RevisionStatusBuilder() {
    this(false);
  }
  public RevisionStatusBuilder(Boolean validationEnabled) {
    this(new RevisionStatus(), validationEnabled);
  }
  public RevisionStatusBuilder(RevisionStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public RevisionStatusBuilder(RevisionStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RevisionStatus(), validationEnabled);
  }
  public RevisionStatusBuilder(RevisionStatusFluent<?> fluent,RevisionStatus instance) {
    this(fluent, instance, false);
  }
  public RevisionStatusBuilder(RevisionStatusFluent<?> fluent,RevisionStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new RevisionStatus());

    if (instance != null) {
      fluent.withActualReplicas(instance.getActualReplicas());
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withConditions(instance.getConditions());
      fluent.withContainerStatuses(instance.getContainerStatuses());
      fluent.withDesiredReplicas(instance.getDesiredReplicas());
      fluent.withInitContainerStatuses(instance.getInitContainerStatuses());
      fluent.withLogUrl(instance.getLogUrl());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withActualReplicas(instance.getActualReplicas());
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withConditions(instance.getConditions());
      fluent.withContainerStatuses(instance.getContainerStatuses());
      fluent.withDesiredReplicas(instance.getDesiredReplicas());
      fluent.withInitContainerStatuses(instance.getInitContainerStatuses());
      fluent.withLogUrl(instance.getLogUrl());
      fluent.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RevisionStatusBuilder(RevisionStatus instance) {
    this(instance,false);
  }
  public RevisionStatusBuilder(RevisionStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new RevisionStatus());

    if (instance != null) {
      this.withActualReplicas(instance.getActualReplicas());
      this.withAnnotations(instance.getAnnotations());
      this.withConditions(instance.getConditions());
      this.withContainerStatuses(instance.getContainerStatuses());
      this.withDesiredReplicas(instance.getDesiredReplicas());
      this.withInitContainerStatuses(instance.getInitContainerStatuses());
      this.withLogUrl(instance.getLogUrl());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withActualReplicas(instance.getActualReplicas());
      this.withAnnotations(instance.getAnnotations());
      this.withConditions(instance.getConditions());
      this.withContainerStatuses(instance.getContainerStatuses());
      this.withDesiredReplicas(instance.getDesiredReplicas());
      this.withInitContainerStatuses(instance.getInitContainerStatuses());
      this.withLogUrl(instance.getLogUrl());
      this.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  RevisionStatusFluent<?> fluent;
  Boolean validationEnabled;
  public RevisionStatus build() {
    RevisionStatus buildable = new RevisionStatus(fluent.getActualReplicas(),fluent.getAnnotations(),fluent.buildConditions(),fluent.buildContainerStatuses(),fluent.getDesiredReplicas(),fluent.buildInitContainerStatuses(),fluent.getLogUrl(),fluent.getObservedGeneration());
    return buildable;
  }
  
}