package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RouteBuilder extends RouteFluent<RouteBuilder> implements VisitableBuilder<Route,RouteBuilder>{
  public RouteBuilder() {
    this(false);
  }
  public RouteBuilder(Boolean validationEnabled) {
    this(new Route(), validationEnabled);
  }
  public RouteBuilder(RouteFluent<?> fluent) {
    this(fluent, false);
  }
  public RouteBuilder(RouteFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Route(), validationEnabled);
  }
  public RouteBuilder(RouteFluent<?> fluent,Route instance) {
    this(fluent, instance, false);
  }
  public RouteBuilder(RouteFluent<?> fluent,Route instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Route());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RouteBuilder(Route instance) {
    this(instance,false);
  }
  public RouteBuilder(Route instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Route());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  RouteFluent<?> fluent;
  Boolean validationEnabled;
  public Route build() {
    Route buildable = new Route(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}