package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceBuilder extends ServiceFluent<ServiceBuilder> implements VisitableBuilder<Service,ServiceBuilder>{
  public ServiceBuilder() {
    this(false);
  }
  public ServiceBuilder(Boolean validationEnabled) {
    this(new Service(), validationEnabled);
  }
  public ServiceBuilder(ServiceFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceBuilder(ServiceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Service(), validationEnabled);
  }
  public ServiceBuilder(ServiceFluent<?> fluent,Service instance) {
    this(fluent, instance, false);
  }
  public ServiceBuilder(ServiceFluent<?> fluent,Service instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Service());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServiceBuilder(Service instance) {
    this(instance,false);
  }
  public ServiceBuilder(Service instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Service());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServiceFluent<?> fluent;
  Boolean validationEnabled;
  public Service build() {
    Service buildable = new Service(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}