package io.fabric8.knative.sources.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class APIVersionKindSelectorBuilder extends APIVersionKindSelectorFluent<APIVersionKindSelectorBuilder> implements VisitableBuilder<APIVersionKindSelector,APIVersionKindSelectorBuilder>{
  public APIVersionKindSelectorBuilder() {
    this(false);
  }
  public APIVersionKindSelectorBuilder(Boolean validationEnabled) {
    this(new APIVersionKindSelector(), validationEnabled);
  }
  public APIVersionKindSelectorBuilder(APIVersionKindSelectorFluent<?> fluent) {
    this(fluent, false);
  }
  public APIVersionKindSelectorBuilder(APIVersionKindSelectorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new APIVersionKindSelector(), validationEnabled);
  }
  public APIVersionKindSelectorBuilder(APIVersionKindSelectorFluent<?> fluent,APIVersionKindSelector instance) {
    this(fluent, instance, false);
  }
  public APIVersionKindSelectorBuilder(APIVersionKindSelectorFluent<?> fluent,APIVersionKindSelector instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new APIVersionKindSelector());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withSelector(instance.getSelector());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withSelector(instance.getSelector());
    }
    this.validationEnabled = validationEnabled; 
  }
  public APIVersionKindSelectorBuilder(APIVersionKindSelector instance) {
    this(instance,false);
  }
  public APIVersionKindSelectorBuilder(APIVersionKindSelector instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new APIVersionKindSelector());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withSelector(instance.getSelector());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withSelector(instance.getSelector());
    }
    this.validationEnabled = validationEnabled; 
  }
  APIVersionKindSelectorFluent<?> fluent;
  Boolean validationEnabled;
  public APIVersionKindSelector build() {
    APIVersionKindSelector buildable = new APIVersionKindSelector(fluent.getApiVersion(),fluent.getKind(),fluent.buildSelector());
    return buildable;
  }
  
}