package io.fabric8.knative.sources.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ContainerSourceSpecBuilder extends ContainerSourceSpecFluent<ContainerSourceSpecBuilder> implements VisitableBuilder<ContainerSourceSpec,ContainerSourceSpecBuilder>{
  public ContainerSourceSpecBuilder() {
    this(false);
  }
  public ContainerSourceSpecBuilder(Boolean validationEnabled) {
    this(new ContainerSourceSpec(), validationEnabled);
  }
  public ContainerSourceSpecBuilder(ContainerSourceSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ContainerSourceSpecBuilder(ContainerSourceSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ContainerSourceSpec(), validationEnabled);
  }
  public ContainerSourceSpecBuilder(ContainerSourceSpecFluent<?> fluent,ContainerSourceSpec instance) {
    this(fluent, instance, false);
  }
  public ContainerSourceSpecBuilder(ContainerSourceSpecFluent<?> fluent,ContainerSourceSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ContainerSourceSpec());

    if (instance != null) {
      fluent.withCeOverrides(instance.getCeOverrides());
      fluent.withSink(instance.getSink());
      fluent.withTemplate(instance.getTemplate());
      fluent.withCeOverrides(instance.getCeOverrides());
      fluent.withSink(instance.getSink());
      fluent.withTemplate(instance.getTemplate());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ContainerSourceSpecBuilder(ContainerSourceSpec instance) {
    this(instance,false);
  }
  public ContainerSourceSpecBuilder(ContainerSourceSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ContainerSourceSpec());

    if (instance != null) {
      this.withCeOverrides(instance.getCeOverrides());
      this.withSink(instance.getSink());
      this.withTemplate(instance.getTemplate());
      this.withCeOverrides(instance.getCeOverrides());
      this.withSink(instance.getSink());
      this.withTemplate(instance.getTemplate());
    }
    this.validationEnabled = validationEnabled; 
  }
  ContainerSourceSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ContainerSourceSpec build() {
    ContainerSourceSpec buildable = new ContainerSourceSpec(fluent.buildCeOverrides(),fluent.buildSink(),fluent.buildTemplate());
    return buildable;
  }
  
}