package io.fabric8.knative.sources.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PingSourceBuilder extends PingSourceFluent<PingSourceBuilder> implements VisitableBuilder<PingSource,PingSourceBuilder>{
  public PingSourceBuilder() {
    this(false);
  }
  public PingSourceBuilder(Boolean validationEnabled) {
    this(new PingSource(), validationEnabled);
  }
  public PingSourceBuilder(PingSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public PingSourceBuilder(PingSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PingSource(), validationEnabled);
  }
  public PingSourceBuilder(PingSourceFluent<?> fluent,PingSource instance) {
    this(fluent, instance, false);
  }
  public PingSourceBuilder(PingSourceFluent<?> fluent,PingSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PingSource());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PingSourceBuilder(PingSource instance) {
    this(instance,false);
  }
  public PingSourceBuilder(PingSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PingSource());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  PingSourceFluent<?> fluent;
  Boolean validationEnabled;
  public PingSource build() {
    PingSource buildable = new PingSource(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}