package io.fabric8.knative.sources.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SinkBindingStatusBuilder extends SinkBindingStatusFluent<SinkBindingStatusBuilder> implements VisitableBuilder<SinkBindingStatus,SinkBindingStatusBuilder>{
  public SinkBindingStatusBuilder() {
    this(false);
  }
  public SinkBindingStatusBuilder(Boolean validationEnabled) {
    this(new SinkBindingStatus(), validationEnabled);
  }
  public SinkBindingStatusBuilder(SinkBindingStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public SinkBindingStatusBuilder(SinkBindingStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SinkBindingStatus(), validationEnabled);
  }
  public SinkBindingStatusBuilder(SinkBindingStatusFluent<?> fluent,SinkBindingStatus instance) {
    this(fluent, instance, false);
  }
  public SinkBindingStatusBuilder(SinkBindingStatusFluent<?> fluent,SinkBindingStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SinkBindingStatus());

    if (instance != null) {
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withCeAttributes(instance.getCeAttributes());
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withSinkCACerts(instance.getSinkCACerts());
      fluent.withSinkUri(instance.getSinkUri());
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withCeAttributes(instance.getCeAttributes());
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withSinkCACerts(instance.getSinkCACerts());
      fluent.withSinkUri(instance.getSinkUri());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SinkBindingStatusBuilder(SinkBindingStatus instance) {
    this(instance,false);
  }
  public SinkBindingStatusBuilder(SinkBindingStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SinkBindingStatus());

    if (instance != null) {
      this.withAnnotations(instance.getAnnotations());
      this.withCeAttributes(instance.getCeAttributes());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withSinkCACerts(instance.getSinkCACerts());
      this.withSinkUri(instance.getSinkUri());
      this.withAnnotations(instance.getAnnotations());
      this.withCeAttributes(instance.getCeAttributes());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withSinkCACerts(instance.getSinkCACerts());
      this.withSinkUri(instance.getSinkUri());
    }
    this.validationEnabled = validationEnabled; 
  }
  SinkBindingStatusFluent<?> fluent;
  Boolean validationEnabled;
  public SinkBindingStatus build() {
    SinkBindingStatus buildable = new SinkBindingStatus(fluent.getAnnotations(),fluent.buildCeAttributes(),fluent.buildConditions(),fluent.getObservedGeneration(),fluent.getSinkCACerts(),fluent.getSinkUri());
    return buildable;
  }
  
}