package io.fabric8.knative.eventing.contrib.awssqs.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class AwsSqsSourceSpecFluent<A extends AwsSqsSourceSpecFluent<A>> extends BaseFluent<A>{
  public AwsSqsSourceSpecFluent() {
  }
  public AwsSqsSourceSpecFluent(AwsSqsSourceSpec instance) {
    instance = (instance != null ? instance : new AwsSqsSourceSpec());

    if (instance != null) {
      this.withAnnotations(instance.getAnnotations());
      this.withAwsCredsSecret(instance.getAwsCredsSecret());
      this.withQueueUrl(instance.getQueueUrl());
      this.withServiceAccountName(instance.getServiceAccountName());
      this.withSink(instance.getSink());
      this.withAnnotations(instance.getAnnotations());
      this.withAwsCredsSecret(instance.getAwsCredsSecret());
      this.withQueueUrl(instance.getQueueUrl());
      this.withServiceAccountName(instance.getServiceAccountName());
      this.withSink(instance.getSink());
    }
  }
  private Map<String,String> annotations;
  private SecretKeySelector awsCredsSecret;
  private String queueUrl;
  private String serviceAccountName;
  private ObjectReferenceBuilder sink;
  public A addToAnnotations(String key,String value) {
    if(this.annotations == null && key != null && value != null) { this.annotations = new LinkedHashMap(); }
    if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
  }
  public A addToAnnotations(Map<String,String> map) {
    if(this.annotations == null && map != null) { this.annotations = new LinkedHashMap(); }
    if(map != null) { this.annotations.putAll(map);} return (A)this;
  }
  public A removeFromAnnotations(String key) {
    if(this.annotations == null) { return (A) this; }
    if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
  }
  public A removeFromAnnotations(Map<String,String> map) {
    if(this.annotations == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
  }
  public Map<String,String> getAnnotations() {
    return this.annotations;
  }
  public <K,V>A withAnnotations(Map<String,String> annotations) {
    if (annotations == null) { this.annotations =  null;} else {this.annotations = new LinkedHashMap(annotations);} return (A) this;
  }
  public boolean hasAnnotations() {
    return this.annotations != null;
  }
  public SecretKeySelector getAwsCredsSecret() {
    return this.awsCredsSecret;
  }
  public A withAwsCredsSecret(SecretKeySelector awsCredsSecret) {
    this.awsCredsSecret=awsCredsSecret; return (A) this;
  }
  public boolean hasAwsCredsSecret() {
    return this.awsCredsSecret != null;
  }
  public A withNewAwsCredsSecret(String key,String name,Boolean optional) {
    return (A)withAwsCredsSecret(new SecretKeySelector(key, name, optional));
  }
  public String getQueueUrl() {
    return this.queueUrl;
  }
  public A withQueueUrl(String queueUrl) {
    this.queueUrl=queueUrl; return (A) this;
  }
  public boolean hasQueueUrl() {
    return this.queueUrl != null;
  }
  public String getServiceAccountName() {
    return this.serviceAccountName;
  }
  public A withServiceAccountName(String serviceAccountName) {
    this.serviceAccountName=serviceAccountName; return (A) this;
  }
  public boolean hasServiceAccountName() {
    return this.serviceAccountName != null;
  }
  public ObjectReference buildSink() {
    return this.sink!=null ?this.sink.build():null;
  }
  public A withSink(ObjectReference sink) {
    _visitables.get("sink").remove(this.sink);
    if (sink!=null){ this.sink= new ObjectReferenceBuilder(sink); _visitables.get("sink").add(this.sink);} else { this.sink = null; _visitables.get("sink").remove(this.sink); } return (A) this;
  }
  public boolean hasSink() {
    return this.sink != null;
  }
  public SinkNested<A> withNewSink() {
    return new SinkNested(null);
  }
  public SinkNested<A> withNewSinkLike(ObjectReference item) {
    return new SinkNested(item);
  }
  public SinkNested<A> editSink() {
    return withNewSinkLike(java.util.Optional.ofNullable(buildSink()).orElse(null));
  }
  public SinkNested<A> editOrNewSink() {
    return withNewSinkLike(java.util.Optional.ofNullable(buildSink()).orElse(new ObjectReferenceBuilder().build()));
  }
  public SinkNested<A> editOrNewSinkLike(ObjectReference item) {
    return withNewSinkLike(java.util.Optional.ofNullable(buildSink()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AwsSqsSourceSpecFluent that = (AwsSqsSourceSpecFluent) o;
    if (!java.util.Objects.equals(annotations, that.annotations)) return false;

    if (!java.util.Objects.equals(awsCredsSecret, that.awsCredsSecret)) return false;

    if (!java.util.Objects.equals(queueUrl, that.queueUrl)) return false;

    if (!java.util.Objects.equals(serviceAccountName, that.serviceAccountName)) return false;

    if (!java.util.Objects.equals(sink, that.sink)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(annotations,  awsCredsSecret,  queueUrl,  serviceAccountName,  sink,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (annotations != null && !annotations.isEmpty()) { sb.append("annotations:"); sb.append(annotations + ","); }
    if (awsCredsSecret != null) { sb.append("awsCredsSecret:"); sb.append(awsCredsSecret + ","); }
    if (queueUrl != null) { sb.append("queueUrl:"); sb.append(queueUrl + ","); }
    if (serviceAccountName != null) { sb.append("serviceAccountName:"); sb.append(serviceAccountName + ","); }
    if (sink != null) { sb.append("sink:"); sb.append(sink); }
    sb.append("}");
    return sb.toString();
  }
  public class SinkNested<N> extends ObjectReferenceFluent<SinkNested<N>> implements Nested<N>{
    SinkNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) AwsSqsSourceSpecFluent.this.withSink(builder.build());
    }
    public N endSink() {
      return and();
    }
    
  }
  
}