package io.fabric8.knative.eventing.contrib.gitlab.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GitLabBindingBuilder extends GitLabBindingFluent<GitLabBindingBuilder> implements VisitableBuilder<GitLabBinding,GitLabBindingBuilder>{
  public GitLabBindingBuilder() {
    this(false);
  }
  public GitLabBindingBuilder(Boolean validationEnabled) {
    this(new GitLabBinding(), validationEnabled);
  }
  public GitLabBindingBuilder(GitLabBindingFluent<?> fluent) {
    this(fluent, false);
  }
  public GitLabBindingBuilder(GitLabBindingFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GitLabBinding(), validationEnabled);
  }
  public GitLabBindingBuilder(GitLabBindingFluent<?> fluent,GitLabBinding instance) {
    this(fluent, instance, false);
  }
  public GitLabBindingBuilder(GitLabBindingFluent<?> fluent,GitLabBinding instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new GitLabBinding());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GitLabBindingBuilder(GitLabBinding instance) {
    this(instance,false);
  }
  public GitLabBindingBuilder(GitLabBinding instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new GitLabBinding());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  GitLabBindingFluent<?> fluent;
  Boolean validationEnabled;
  public GitLabBinding build() {
    GitLabBinding buildable = new GitLabBinding(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}