package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaBindingBuilder extends KafkaBindingFluent<KafkaBindingBuilder> implements VisitableBuilder<KafkaBinding,KafkaBindingBuilder>{
  public KafkaBindingBuilder() {
    this(false);
  }
  public KafkaBindingBuilder(Boolean validationEnabled) {
    this(new KafkaBinding(), validationEnabled);
  }
  public KafkaBindingBuilder(KafkaBindingFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaBindingBuilder(KafkaBindingFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaBinding(), validationEnabled);
  }
  public KafkaBindingBuilder(KafkaBindingFluent<?> fluent,KafkaBinding instance) {
    this(fluent, instance, false);
  }
  public KafkaBindingBuilder(KafkaBindingFluent<?> fluent,KafkaBinding instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaBinding());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaBindingBuilder(KafkaBinding instance) {
    this(instance,false);
  }
  public KafkaBindingBuilder(KafkaBinding instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaBinding());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaBindingFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaBinding build() {
    KafkaBinding buildable = new KafkaBinding(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}