package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.knative.internal.pkg.tracker.Reference;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.knative.internal.pkg.tracker.ReferenceFluent;
import io.fabric8.knative.internal.pkg.tracker.ReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KafkaBindingSpecFluent<A extends KafkaBindingSpecFluent<A>> extends BaseFluent<A>{
  public KafkaBindingSpecFluent() {
  }
  public KafkaBindingSpecFluent(KafkaBindingSpec instance) {
    instance = (instance != null ? instance : new KafkaBindingSpec());

    if (instance != null) {
      this.withBootstrapServers(instance.getBootstrapServers());
      this.withNet(instance.getNet());
      this.withSubject(instance.getSubject());
      this.withBootstrapServers(instance.getBootstrapServers());
      this.withNet(instance.getNet());
      this.withSubject(instance.getSubject());
    }
  }
  private List<String> bootstrapServers = new ArrayList<String>();
  private KafkaNetSpecBuilder net;
  private ReferenceBuilder subject;
  public A addToBootstrapServers(int index,String item) {
    if (this.bootstrapServers == null) {this.bootstrapServers = new ArrayList<String>();}
    this.bootstrapServers.add(index, item);
    return (A)this;
  }
  public A setToBootstrapServers(int index,String item) {
    if (this.bootstrapServers == null) {this.bootstrapServers = new ArrayList<String>();}
    this.bootstrapServers.set(index, item); return (A)this;
  }
  public A addToBootstrapServers(java.lang.String... items) {
    if (this.bootstrapServers == null) {this.bootstrapServers = new ArrayList<String>();}
    for (String item : items) {this.bootstrapServers.add(item);} return (A)this;
  }
  public A addAllToBootstrapServers(Collection<String> items) {
    if (this.bootstrapServers == null) {this.bootstrapServers = new ArrayList<String>();}
    for (String item : items) {this.bootstrapServers.add(item);} return (A)this;
  }
  public A removeFromBootstrapServers(java.lang.String... items) {
    if (this.bootstrapServers == null) return (A)this;
    for (String item : items) { this.bootstrapServers.remove(item);} return (A)this;
  }
  public A removeAllFromBootstrapServers(Collection<String> items) {
    if (this.bootstrapServers == null) return (A)this;
    for (String item : items) { this.bootstrapServers.remove(item);} return (A)this;
  }
  public List<String> getBootstrapServers() {
    return this.bootstrapServers;
  }
  public String getBootstrapServer(int index) {
    return this.bootstrapServers.get(index);
  }
  public String getFirstBootstrapServer() {
    return this.bootstrapServers.get(0);
  }
  public String getLastBootstrapServer() {
    return this.bootstrapServers.get(bootstrapServers.size() - 1);
  }
  public String getMatchingBootstrapServer(Predicate<String> predicate) {
    for (String item: bootstrapServers) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingBootstrapServer(Predicate<String> predicate) {
    for (String item: bootstrapServers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withBootstrapServers(List<String> bootstrapServers) {
    if (bootstrapServers != null) {this.bootstrapServers = new ArrayList(); for (String item : bootstrapServers){this.addToBootstrapServers(item);}} else { this.bootstrapServers = null;} return (A) this;
  }
  public A withBootstrapServers(java.lang.String... bootstrapServers) {
    if (this.bootstrapServers != null) {this.bootstrapServers.clear(); _visitables.remove("bootstrapServers"); }
    if (bootstrapServers != null) {for (String item :bootstrapServers){ this.addToBootstrapServers(item);}} return (A) this;
  }
  public boolean hasBootstrapServers() {
    return bootstrapServers != null && !bootstrapServers.isEmpty();
  }
  public KafkaNetSpec buildNet() {
    return this.net!=null ?this.net.build():null;
  }
  public A withNet(KafkaNetSpec net) {
    _visitables.get("net").remove(this.net);
    if (net!=null){ this.net= new KafkaNetSpecBuilder(net); _visitables.get("net").add(this.net);} else { this.net = null; _visitables.get("net").remove(this.net); } return (A) this;
  }
  public boolean hasNet() {
    return this.net != null;
  }
  public NetNested<A> withNewNet() {
    return new NetNested(null);
  }
  public NetNested<A> withNewNetLike(KafkaNetSpec item) {
    return new NetNested(item);
  }
  public NetNested<A> editNet() {
    return withNewNetLike(java.util.Optional.ofNullable(buildNet()).orElse(null));
  }
  public NetNested<A> editOrNewNet() {
    return withNewNetLike(java.util.Optional.ofNullable(buildNet()).orElse(new KafkaNetSpecBuilder().build()));
  }
  public NetNested<A> editOrNewNetLike(KafkaNetSpec item) {
    return withNewNetLike(java.util.Optional.ofNullable(buildNet()).orElse(item));
  }
  public Reference buildSubject() {
    return this.subject!=null ?this.subject.build():null;
  }
  public A withSubject(Reference subject) {
    _visitables.get("subject").remove(this.subject);
    if (subject!=null){ this.subject= new ReferenceBuilder(subject); _visitables.get("subject").add(this.subject);} else { this.subject = null; _visitables.get("subject").remove(this.subject); } return (A) this;
  }
  public boolean hasSubject() {
    return this.subject != null;
  }
  public SubjectNested<A> withNewSubject() {
    return new SubjectNested(null);
  }
  public SubjectNested<A> withNewSubjectLike(Reference item) {
    return new SubjectNested(item);
  }
  public SubjectNested<A> editSubject() {
    return withNewSubjectLike(java.util.Optional.ofNullable(buildSubject()).orElse(null));
  }
  public SubjectNested<A> editOrNewSubject() {
    return withNewSubjectLike(java.util.Optional.ofNullable(buildSubject()).orElse(new ReferenceBuilder().build()));
  }
  public SubjectNested<A> editOrNewSubjectLike(Reference item) {
    return withNewSubjectLike(java.util.Optional.ofNullable(buildSubject()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaBindingSpecFluent that = (KafkaBindingSpecFluent) o;
    if (!java.util.Objects.equals(bootstrapServers, that.bootstrapServers)) return false;

    if (!java.util.Objects.equals(net, that.net)) return false;

    if (!java.util.Objects.equals(subject, that.subject)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(bootstrapServers,  net,  subject,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bootstrapServers != null && !bootstrapServers.isEmpty()) { sb.append("bootstrapServers:"); sb.append(bootstrapServers + ","); }
    if (net != null) { sb.append("net:"); sb.append(net + ","); }
    if (subject != null) { sb.append("subject:"); sb.append(subject); }
    sb.append("}");
    return sb.toString();
  }
  public class NetNested<N> extends KafkaNetSpecFluent<NetNested<N>> implements Nested<N>{
    NetNested(KafkaNetSpec item) {
      this.builder = new KafkaNetSpecBuilder(this, item);
    }
    KafkaNetSpecBuilder builder;
    public N and() {
      return (N) KafkaBindingSpecFluent.this.withNet(builder.build());
    }
    public N endNet() {
      return and();
    }
    
  }
  public class SubjectNested<N> extends ReferenceFluent<SubjectNested<N>> implements Nested<N>{
    SubjectNested(Reference item) {
      this.builder = new ReferenceBuilder(this, item);
    }
    ReferenceBuilder builder;
    public N and() {
      return (N) KafkaBindingSpecFluent.this.withSubject(builder.build());
    }
    public N endSubject() {
      return and();
    }
    
  }
  
}