package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaChannelBuilder extends KafkaChannelFluent<KafkaChannelBuilder> implements VisitableBuilder<KafkaChannel,KafkaChannelBuilder>{
  public KafkaChannelBuilder() {
    this(false);
  }
  public KafkaChannelBuilder(Boolean validationEnabled) {
    this(new KafkaChannel(), validationEnabled);
  }
  public KafkaChannelBuilder(KafkaChannelFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaChannelBuilder(KafkaChannelFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaChannel(), validationEnabled);
  }
  public KafkaChannelBuilder(KafkaChannelFluent<?> fluent,KafkaChannel instance) {
    this(fluent, instance, false);
  }
  public KafkaChannelBuilder(KafkaChannelFluent<?> fluent,KafkaChannel instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaChannel());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaChannelBuilder(KafkaChannel instance) {
    this(instance,false);
  }
  public KafkaChannelBuilder(KafkaChannel instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaChannel());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaChannelFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaChannel build() {
    KafkaChannel buildable = new KafkaChannel(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}