package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventAttributesBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventAttributesFluent;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1alpha1.Placement;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventAttributes;
import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1alpha1.PlacementBuilder;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1alpha1.PlacementFluent;
import io.fabric8.knative.internal.pkg.apis.ConditionFluent;
import java.lang.Integer;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KafkaSourceStatusFluent<A extends KafkaSourceStatusFluent<A>> extends BaseFluent<A>{
  public KafkaSourceStatusFluent() {
  }
  public KafkaSourceStatusFluent(KafkaSourceStatus instance) {
    instance = (instance != null ? instance : new KafkaSourceStatus());

    if (instance != null) {
      this.withAnnotations(instance.getAnnotations());
      this.withCeAttributes(instance.getCeAttributes());
      this.withClaims(instance.getClaims());
      this.withConditions(instance.getConditions());
      this.withConsumers(instance.getConsumers());
      this.withMaxAllowedVReplicas(instance.getMaxAllowedVReplicas());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withPlacements(instance.getPlacements());
      this.withSelector(instance.getSelector());
      this.withSinkCACerts(instance.getSinkCACerts());
      this.withSinkUri(instance.getSinkUri());
      this.withAnnotations(instance.getAnnotations());
      this.withCeAttributes(instance.getCeAttributes());
      this.withClaims(instance.getClaims());
      this.withConditions(instance.getConditions());
      this.withConsumers(instance.getConsumers());
      this.withMaxAllowedVReplicas(instance.getMaxAllowedVReplicas());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withPlacements(instance.getPlacements());
      this.withSelector(instance.getSelector());
      this.withSinkCACerts(instance.getSinkCACerts());
      this.withSinkUri(instance.getSinkUri());
    }
  }
  private Map<String,String> annotations;
  private ArrayList<CloudEventAttributesBuilder> ceAttributes = new ArrayList<CloudEventAttributesBuilder>();
  private String claims;
  private ArrayList<ConditionBuilder> conditions = new ArrayList<ConditionBuilder>();
  private Integer consumers;
  private Integer maxAllowedVReplicas;
  private Long observedGeneration;
  private ArrayList<PlacementBuilder> placements = new ArrayList<PlacementBuilder>();
  private String selector;
  private String sinkCACerts;
  private String sinkUri;
  public A addToAnnotations(String key,String value) {
    if(this.annotations == null && key != null && value != null) { this.annotations = new LinkedHashMap(); }
    if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
  }
  public A addToAnnotations(Map<String,String> map) {
    if(this.annotations == null && map != null) { this.annotations = new LinkedHashMap(); }
    if(map != null) { this.annotations.putAll(map);} return (A)this;
  }
  public A removeFromAnnotations(String key) {
    if(this.annotations == null) { return (A) this; }
    if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
  }
  public A removeFromAnnotations(Map<String,String> map) {
    if(this.annotations == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
  }
  public Map<String,String> getAnnotations() {
    return this.annotations;
  }
  public <K,V>A withAnnotations(Map<String,String> annotations) {
    if (annotations == null) { this.annotations =  null;} else {this.annotations = new LinkedHashMap(annotations);} return (A) this;
  }
  public boolean hasAnnotations() {
    return this.annotations != null;
  }
  public A addToCeAttributes(int index,CloudEventAttributes item) {
    if (this.ceAttributes == null) {this.ceAttributes = new ArrayList<CloudEventAttributesBuilder>();}
    CloudEventAttributesBuilder builder = new CloudEventAttributesBuilder(item);
    if (index < 0 || index >= ceAttributes.size()) { _visitables.get("ceAttributes").add(builder); ceAttributes.add(builder); } else { _visitables.get("ceAttributes").add(index, builder); ceAttributes.add(index, builder);}
    return (A)this;
  }
  public A setToCeAttributes(int index,CloudEventAttributes item) {
    if (this.ceAttributes == null) {this.ceAttributes = new ArrayList<CloudEventAttributesBuilder>();}
    CloudEventAttributesBuilder builder = new CloudEventAttributesBuilder(item);
    if (index < 0 || index >= ceAttributes.size()) { _visitables.get("ceAttributes").add(builder); ceAttributes.add(builder); } else { _visitables.get("ceAttributes").set(index, builder); ceAttributes.set(index, builder);}
    return (A)this;
  }
  public A addToCeAttributes(io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventAttributes... items) {
    if (this.ceAttributes == null) {this.ceAttributes = new ArrayList<CloudEventAttributesBuilder>();}
    for (CloudEventAttributes item : items) {CloudEventAttributesBuilder builder = new CloudEventAttributesBuilder(item);_visitables.get("ceAttributes").add(builder);this.ceAttributes.add(builder);} return (A)this;
  }
  public A addAllToCeAttributes(Collection<CloudEventAttributes> items) {
    if (this.ceAttributes == null) {this.ceAttributes = new ArrayList<CloudEventAttributesBuilder>();}
    for (CloudEventAttributes item : items) {CloudEventAttributesBuilder builder = new CloudEventAttributesBuilder(item);_visitables.get("ceAttributes").add(builder);this.ceAttributes.add(builder);} return (A)this;
  }
  public A removeFromCeAttributes(io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventAttributes... items) {
    if (this.ceAttributes == null) return (A)this;
    for (CloudEventAttributes item : items) {CloudEventAttributesBuilder builder = new CloudEventAttributesBuilder(item);_visitables.get("ceAttributes").remove(builder); this.ceAttributes.remove(builder);} return (A)this;
  }
  public A removeAllFromCeAttributes(Collection<CloudEventAttributes> items) {
    if (this.ceAttributes == null) return (A)this;
    for (CloudEventAttributes item : items) {CloudEventAttributesBuilder builder = new CloudEventAttributesBuilder(item);_visitables.get("ceAttributes").remove(builder); this.ceAttributes.remove(builder);} return (A)this;
  }
  public A removeMatchingFromCeAttributes(Predicate<CloudEventAttributesBuilder> predicate) {
    if (ceAttributes == null) return (A) this;
    final Iterator<CloudEventAttributesBuilder> each = ceAttributes.iterator();
    final List visitables = _visitables.get("ceAttributes");
    while (each.hasNext()) {
      CloudEventAttributesBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<CloudEventAttributes> buildCeAttributes() {
    return ceAttributes != null ? build(ceAttributes) : null;
  }
  public CloudEventAttributes buildCeAttribute(int index) {
    return this.ceAttributes.get(index).build();
  }
  public CloudEventAttributes buildFirstCeAttribute() {
    return this.ceAttributes.get(0).build();
  }
  public CloudEventAttributes buildLastCeAttribute() {
    return this.ceAttributes.get(ceAttributes.size() - 1).build();
  }
  public CloudEventAttributes buildMatchingCeAttribute(Predicate<CloudEventAttributesBuilder> predicate) {
    for (CloudEventAttributesBuilder item: ceAttributes) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingCeAttribute(Predicate<CloudEventAttributesBuilder> predicate) {
    for (CloudEventAttributesBuilder item: ceAttributes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withCeAttributes(List<CloudEventAttributes> ceAttributes) {
    if (this.ceAttributes != null) { _visitables.get("ceAttributes").clear();}
    if (ceAttributes != null) {this.ceAttributes = new ArrayList(); for (CloudEventAttributes item : ceAttributes){this.addToCeAttributes(item);}} else { this.ceAttributes = null;} return (A) this;
  }
  public A withCeAttributes(io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventAttributes... ceAttributes) {
    if (this.ceAttributes != null) {this.ceAttributes.clear(); _visitables.remove("ceAttributes"); }
    if (ceAttributes != null) {for (CloudEventAttributes item :ceAttributes){ this.addToCeAttributes(item);}} return (A) this;
  }
  public boolean hasCeAttributes() {
    return ceAttributes != null && !ceAttributes.isEmpty();
  }
  public A addNewCeAttribute(String source,String type) {
    return (A)addToCeAttributes(new CloudEventAttributes(source, type));
  }
  public CeAttributesNested<A> addNewCeAttribute() {
    return new CeAttributesNested(-1, null);
  }
  public CeAttributesNested<A> addNewCeAttributeLike(CloudEventAttributes item) {
    return new CeAttributesNested(-1, item);
  }
  public CeAttributesNested<A> setNewCeAttributeLike(int index,CloudEventAttributes item) {
    return new CeAttributesNested(index, item);
  }
  public CeAttributesNested<A> editCeAttribute(int index) {
    if (ceAttributes.size() <= index) throw new RuntimeException("Can't edit ceAttributes. Index exceeds size.");
    return setNewCeAttributeLike(index, buildCeAttribute(index));
  }
  public CeAttributesNested<A> editFirstCeAttribute() {
    if (ceAttributes.size() == 0) throw new RuntimeException("Can't edit first ceAttributes. The list is empty.");
    return setNewCeAttributeLike(0, buildCeAttribute(0));
  }
  public CeAttributesNested<A> editLastCeAttribute() {
    int index = ceAttributes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last ceAttributes. The list is empty.");
    return setNewCeAttributeLike(index, buildCeAttribute(index));
  }
  public CeAttributesNested<A> editMatchingCeAttribute(Predicate<CloudEventAttributesBuilder> predicate) {
    int index = -1;
    for (int i=0;i<ceAttributes.size();i++) { 
    if (predicate.test(ceAttributes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching ceAttributes. No match found.");
    return setNewCeAttributeLike(index, buildCeAttribute(index));
  }
  public String getClaims() {
    return this.claims;
  }
  public A withClaims(String claims) {
    this.claims=claims; return (A) this;
  }
  public boolean hasClaims() {
    return this.claims != null;
  }
  public A addToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    ConditionBuilder builder = new ConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  public A setToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    ConditionBuilder builder = new ConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  public A addToConditions(io.fabric8.knative.internal.pkg.apis.Condition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<Condition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.knative.internal.pkg.apis.Condition... items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  public A removeAllFromConditions(Collection<Condition> items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<ConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      ConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<Condition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public Condition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  public Condition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public Condition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
    for (ConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
    for (ConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<Condition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").clear();}
    if (conditions != null) {this.conditions = new ArrayList(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.knative.internal.pkg.apis.Condition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public ConditionsNested<A> addNewCondition() {
    return new ConditionsNested(-1, null);
  }
  public ConditionsNested<A> addNewConditionLike(Condition item) {
    return new ConditionsNested(-1, item);
  }
  public ConditionsNested<A> setNewConditionLike(int index,Condition item) {
    return new ConditionsNested(index, item);
  }
  public ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public Integer getConsumers() {
    return this.consumers;
  }
  public A withConsumers(Integer consumers) {
    this.consumers=consumers; return (A) this;
  }
  public boolean hasConsumers() {
    return this.consumers != null;
  }
  public Integer getMaxAllowedVReplicas() {
    return this.maxAllowedVReplicas;
  }
  public A withMaxAllowedVReplicas(Integer maxAllowedVReplicas) {
    this.maxAllowedVReplicas=maxAllowedVReplicas; return (A) this;
  }
  public boolean hasMaxAllowedVReplicas() {
    return this.maxAllowedVReplicas != null;
  }
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration=observedGeneration; return (A) this;
  }
  public boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  public A addToPlacements(int index,Placement item) {
    if (this.placements == null) {this.placements = new ArrayList<PlacementBuilder>();}
    PlacementBuilder builder = new PlacementBuilder(item);
    if (index < 0 || index >= placements.size()) { _visitables.get("placements").add(builder); placements.add(builder); } else { _visitables.get("placements").add(index, builder); placements.add(index, builder);}
    return (A)this;
  }
  public A setToPlacements(int index,Placement item) {
    if (this.placements == null) {this.placements = new ArrayList<PlacementBuilder>();}
    PlacementBuilder builder = new PlacementBuilder(item);
    if (index < 0 || index >= placements.size()) { _visitables.get("placements").add(builder); placements.add(builder); } else { _visitables.get("placements").set(index, builder); placements.set(index, builder);}
    return (A)this;
  }
  public A addToPlacements(io.fabric8.knative.internal.eventing.pkg.apis.duck.v1alpha1.Placement... items) {
    if (this.placements == null) {this.placements = new ArrayList<PlacementBuilder>();}
    for (Placement item : items) {PlacementBuilder builder = new PlacementBuilder(item);_visitables.get("placements").add(builder);this.placements.add(builder);} return (A)this;
  }
  public A addAllToPlacements(Collection<Placement> items) {
    if (this.placements == null) {this.placements = new ArrayList<PlacementBuilder>();}
    for (Placement item : items) {PlacementBuilder builder = new PlacementBuilder(item);_visitables.get("placements").add(builder);this.placements.add(builder);} return (A)this;
  }
  public A removeFromPlacements(io.fabric8.knative.internal.eventing.pkg.apis.duck.v1alpha1.Placement... items) {
    if (this.placements == null) return (A)this;
    for (Placement item : items) {PlacementBuilder builder = new PlacementBuilder(item);_visitables.get("placements").remove(builder); this.placements.remove(builder);} return (A)this;
  }
  public A removeAllFromPlacements(Collection<Placement> items) {
    if (this.placements == null) return (A)this;
    for (Placement item : items) {PlacementBuilder builder = new PlacementBuilder(item);_visitables.get("placements").remove(builder); this.placements.remove(builder);} return (A)this;
  }
  public A removeMatchingFromPlacements(Predicate<PlacementBuilder> predicate) {
    if (placements == null) return (A) this;
    final Iterator<PlacementBuilder> each = placements.iterator();
    final List visitables = _visitables.get("placements");
    while (each.hasNext()) {
      PlacementBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<Placement> buildPlacements() {
    return placements != null ? build(placements) : null;
  }
  public Placement buildPlacement(int index) {
    return this.placements.get(index).build();
  }
  public Placement buildFirstPlacement() {
    return this.placements.get(0).build();
  }
  public Placement buildLastPlacement() {
    return this.placements.get(placements.size() - 1).build();
  }
  public Placement buildMatchingPlacement(Predicate<PlacementBuilder> predicate) {
    for (PlacementBuilder item: placements) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingPlacement(Predicate<PlacementBuilder> predicate) {
    for (PlacementBuilder item: placements) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPlacements(List<Placement> placements) {
    if (this.placements != null) { _visitables.get("placements").clear();}
    if (placements != null) {this.placements = new ArrayList(); for (Placement item : placements){this.addToPlacements(item);}} else { this.placements = null;} return (A) this;
  }
  public A withPlacements(io.fabric8.knative.internal.eventing.pkg.apis.duck.v1alpha1.Placement... placements) {
    if (this.placements != null) {this.placements.clear(); _visitables.remove("placements"); }
    if (placements != null) {for (Placement item :placements){ this.addToPlacements(item);}} return (A) this;
  }
  public boolean hasPlacements() {
    return placements != null && !placements.isEmpty();
  }
  public A addNewPlacement(String podName,Integer vreplicas) {
    return (A)addToPlacements(new Placement(podName, vreplicas));
  }
  public PlacementsNested<A> addNewPlacement() {
    return new PlacementsNested(-1, null);
  }
  public PlacementsNested<A> addNewPlacementLike(Placement item) {
    return new PlacementsNested(-1, item);
  }
  public PlacementsNested<A> setNewPlacementLike(int index,Placement item) {
    return new PlacementsNested(index, item);
  }
  public PlacementsNested<A> editPlacement(int index) {
    if (placements.size() <= index) throw new RuntimeException("Can't edit placements. Index exceeds size.");
    return setNewPlacementLike(index, buildPlacement(index));
  }
  public PlacementsNested<A> editFirstPlacement() {
    if (placements.size() == 0) throw new RuntimeException("Can't edit first placements. The list is empty.");
    return setNewPlacementLike(0, buildPlacement(0));
  }
  public PlacementsNested<A> editLastPlacement() {
    int index = placements.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last placements. The list is empty.");
    return setNewPlacementLike(index, buildPlacement(index));
  }
  public PlacementsNested<A> editMatchingPlacement(Predicate<PlacementBuilder> predicate) {
    int index = -1;
    for (int i=0;i<placements.size();i++) { 
    if (predicate.test(placements.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching placements. No match found.");
    return setNewPlacementLike(index, buildPlacement(index));
  }
  public String getSelector() {
    return this.selector;
  }
  public A withSelector(String selector) {
    this.selector=selector; return (A) this;
  }
  public boolean hasSelector() {
    return this.selector != null;
  }
  public String getSinkCACerts() {
    return this.sinkCACerts;
  }
  public A withSinkCACerts(String sinkCACerts) {
    this.sinkCACerts=sinkCACerts; return (A) this;
  }
  public boolean hasSinkCACerts() {
    return this.sinkCACerts != null;
  }
  public String getSinkUri() {
    return this.sinkUri;
  }
  public A withSinkUri(String sinkUri) {
    this.sinkUri=sinkUri; return (A) this;
  }
  public boolean hasSinkUri() {
    return this.sinkUri != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaSourceStatusFluent that = (KafkaSourceStatusFluent) o;
    if (!java.util.Objects.equals(annotations, that.annotations)) return false;

    if (!java.util.Objects.equals(ceAttributes, that.ceAttributes)) return false;

    if (!java.util.Objects.equals(claims, that.claims)) return false;

    if (!java.util.Objects.equals(conditions, that.conditions)) return false;

    if (!java.util.Objects.equals(consumers, that.consumers)) return false;

    if (!java.util.Objects.equals(maxAllowedVReplicas, that.maxAllowedVReplicas)) return false;

    if (!java.util.Objects.equals(observedGeneration, that.observedGeneration)) return false;

    if (!java.util.Objects.equals(placements, that.placements)) return false;

    if (!java.util.Objects.equals(selector, that.selector)) return false;

    if (!java.util.Objects.equals(sinkCACerts, that.sinkCACerts)) return false;

    if (!java.util.Objects.equals(sinkUri, that.sinkUri)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(annotations,  ceAttributes,  claims,  conditions,  consumers,  maxAllowedVReplicas,  observedGeneration,  placements,  selector,  sinkCACerts,  sinkUri,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (annotations != null && !annotations.isEmpty()) { sb.append("annotations:"); sb.append(annotations + ","); }
    if (ceAttributes != null && !ceAttributes.isEmpty()) { sb.append("ceAttributes:"); sb.append(ceAttributes + ","); }
    if (claims != null) { sb.append("claims:"); sb.append(claims + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (consumers != null) { sb.append("consumers:"); sb.append(consumers + ","); }
    if (maxAllowedVReplicas != null) { sb.append("maxAllowedVReplicas:"); sb.append(maxAllowedVReplicas + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration + ","); }
    if (placements != null && !placements.isEmpty()) { sb.append("placements:"); sb.append(placements + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (sinkCACerts != null) { sb.append("sinkCACerts:"); sb.append(sinkCACerts + ","); }
    if (sinkUri != null) { sb.append("sinkUri:"); sb.append(sinkUri); }
    sb.append("}");
    return sb.toString();
  }
  public class CeAttributesNested<N> extends CloudEventAttributesFluent<CeAttributesNested<N>> implements Nested<N>{
    CeAttributesNested(int index,CloudEventAttributes item) {
      this.index = index;
      this.builder = new CloudEventAttributesBuilder(this, item);
    }
    CloudEventAttributesBuilder builder;
    int index;
    public N and() {
      return (N) KafkaSourceStatusFluent.this.setToCeAttributes(index,builder.build());
    }
    public N endCeAttribute() {
      return and();
    }
    
  }
  public class ConditionsNested<N> extends ConditionFluent<ConditionsNested<N>> implements Nested<N>{
    ConditionsNested(int index,Condition item) {
      this.index = index;
      this.builder = new ConditionBuilder(this, item);
    }
    ConditionBuilder builder;
    int index;
    public N and() {
      return (N) KafkaSourceStatusFluent.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  public class PlacementsNested<N> extends PlacementFluent<PlacementsNested<N>> implements Nested<N>{
    PlacementsNested(int index,Placement item) {
      this.index = index;
      this.builder = new PlacementBuilder(this, item);
    }
    PlacementBuilder builder;
    int index;
    public N and() {
      return (N) KafkaSourceStatusFluent.this.setToPlacements(index,builder.build());
    }
    public N endPlacement() {
      return and();
    }
    
  }
  
}