package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaTLSSpecBuilder extends KafkaTLSSpecFluent<KafkaTLSSpecBuilder> implements VisitableBuilder<KafkaTLSSpec,KafkaTLSSpecBuilder>{
  public KafkaTLSSpecBuilder() {
    this(false);
  }
  public KafkaTLSSpecBuilder(Boolean validationEnabled) {
    this(new KafkaTLSSpec(), validationEnabled);
  }
  public KafkaTLSSpecBuilder(KafkaTLSSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaTLSSpecBuilder(KafkaTLSSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaTLSSpec(), validationEnabled);
  }
  public KafkaTLSSpecBuilder(KafkaTLSSpecFluent<?> fluent,KafkaTLSSpec instance) {
    this(fluent, instance, false);
  }
  public KafkaTLSSpecBuilder(KafkaTLSSpecFluent<?> fluent,KafkaTLSSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaTLSSpec());

    if (instance != null) {
      fluent.withCaCert(instance.getCaCert());
      fluent.withCert(instance.getCert());
      fluent.withEnable(instance.getEnable());
      fluent.withKey(instance.getKey());
      fluent.withCaCert(instance.getCaCert());
      fluent.withCert(instance.getCert());
      fluent.withEnable(instance.getEnable());
      fluent.withKey(instance.getKey());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaTLSSpecBuilder(KafkaTLSSpec instance) {
    this(instance,false);
  }
  public KafkaTLSSpecBuilder(KafkaTLSSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaTLSSpec());

    if (instance != null) {
      this.withCaCert(instance.getCaCert());
      this.withCert(instance.getCert());
      this.withEnable(instance.getEnable());
      this.withKey(instance.getKey());
      this.withCaCert(instance.getCaCert());
      this.withCert(instance.getCert());
      this.withEnable(instance.getEnable());
      this.withKey(instance.getKey());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaTLSSpecFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaTLSSpec build() {
    KafkaTLSSpec buildable = new KafkaTLSSpec(fluent.buildCaCert(),fluent.buildCert(),fluent.getEnable(),fluent.buildKey());
    return buildable;
  }
  
}