package io.fabric8.knative.eventing.contrib.prometheus.v1alpha1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventAttributesBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventAttributesFluent;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventAttributes;
import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.knative.internal.pkg.apis.ConditionFluent;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PrometheusSourceStatusFluent<A extends PrometheusSourceStatusFluent<A>> extends BaseFluent<A>{
  public PrometheusSourceStatusFluent() {
  }
  public PrometheusSourceStatusFluent(PrometheusSourceStatus instance) {
    instance = (instance != null ? instance : new PrometheusSourceStatus());

    if (instance != null) {
      this.withAnnotations(instance.getAnnotations());
      this.withCeAttributes(instance.getCeAttributes());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withSinkCACerts(instance.getSinkCACerts());
      this.withSinkUri(instance.getSinkUri());
      this.withAnnotations(instance.getAnnotations());
      this.withCeAttributes(instance.getCeAttributes());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withSinkCACerts(instance.getSinkCACerts());
      this.withSinkUri(instance.getSinkUri());
    }
  }
  private Map<String,String> annotations;
  private ArrayList<CloudEventAttributesBuilder> ceAttributes = new ArrayList<CloudEventAttributesBuilder>();
  private ArrayList<ConditionBuilder> conditions = new ArrayList<ConditionBuilder>();
  private Long observedGeneration;
  private String sinkCACerts;
  private String sinkUri;
  public A addToAnnotations(String key,String value) {
    if(this.annotations == null && key != null && value != null) { this.annotations = new LinkedHashMap(); }
    if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
  }
  public A addToAnnotations(Map<String,String> map) {
    if(this.annotations == null && map != null) { this.annotations = new LinkedHashMap(); }
    if(map != null) { this.annotations.putAll(map);} return (A)this;
  }
  public A removeFromAnnotations(String key) {
    if(this.annotations == null) { return (A) this; }
    if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
  }
  public A removeFromAnnotations(Map<String,String> map) {
    if(this.annotations == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
  }
  public Map<String,String> getAnnotations() {
    return this.annotations;
  }
  public <K,V>A withAnnotations(Map<String,String> annotations) {
    if (annotations == null) { this.annotations =  null;} else {this.annotations = new LinkedHashMap(annotations);} return (A) this;
  }
  public boolean hasAnnotations() {
    return this.annotations != null;
  }
  public A addToCeAttributes(int index,CloudEventAttributes item) {
    if (this.ceAttributes == null) {this.ceAttributes = new ArrayList<CloudEventAttributesBuilder>();}
    CloudEventAttributesBuilder builder = new CloudEventAttributesBuilder(item);
    if (index < 0 || index >= ceAttributes.size()) { _visitables.get("ceAttributes").add(builder); ceAttributes.add(builder); } else { _visitables.get("ceAttributes").add(index, builder); ceAttributes.add(index, builder);}
    return (A)this;
  }
  public A setToCeAttributes(int index,CloudEventAttributes item) {
    if (this.ceAttributes == null) {this.ceAttributes = new ArrayList<CloudEventAttributesBuilder>();}
    CloudEventAttributesBuilder builder = new CloudEventAttributesBuilder(item);
    if (index < 0 || index >= ceAttributes.size()) { _visitables.get("ceAttributes").add(builder); ceAttributes.add(builder); } else { _visitables.get("ceAttributes").set(index, builder); ceAttributes.set(index, builder);}
    return (A)this;
  }
  public A addToCeAttributes(io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventAttributes... items) {
    if (this.ceAttributes == null) {this.ceAttributes = new ArrayList<CloudEventAttributesBuilder>();}
    for (CloudEventAttributes item : items) {CloudEventAttributesBuilder builder = new CloudEventAttributesBuilder(item);_visitables.get("ceAttributes").add(builder);this.ceAttributes.add(builder);} return (A)this;
  }
  public A addAllToCeAttributes(Collection<CloudEventAttributes> items) {
    if (this.ceAttributes == null) {this.ceAttributes = new ArrayList<CloudEventAttributesBuilder>();}
    for (CloudEventAttributes item : items) {CloudEventAttributesBuilder builder = new CloudEventAttributesBuilder(item);_visitables.get("ceAttributes").add(builder);this.ceAttributes.add(builder);} return (A)this;
  }
  public A removeFromCeAttributes(io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventAttributes... items) {
    if (this.ceAttributes == null) return (A)this;
    for (CloudEventAttributes item : items) {CloudEventAttributesBuilder builder = new CloudEventAttributesBuilder(item);_visitables.get("ceAttributes").remove(builder); this.ceAttributes.remove(builder);} return (A)this;
  }
  public A removeAllFromCeAttributes(Collection<CloudEventAttributes> items) {
    if (this.ceAttributes == null) return (A)this;
    for (CloudEventAttributes item : items) {CloudEventAttributesBuilder builder = new CloudEventAttributesBuilder(item);_visitables.get("ceAttributes").remove(builder); this.ceAttributes.remove(builder);} return (A)this;
  }
  public A removeMatchingFromCeAttributes(Predicate<CloudEventAttributesBuilder> predicate) {
    if (ceAttributes == null) return (A) this;
    final Iterator<CloudEventAttributesBuilder> each = ceAttributes.iterator();
    final List visitables = _visitables.get("ceAttributes");
    while (each.hasNext()) {
      CloudEventAttributesBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<CloudEventAttributes> buildCeAttributes() {
    return ceAttributes != null ? build(ceAttributes) : null;
  }
  public CloudEventAttributes buildCeAttribute(int index) {
    return this.ceAttributes.get(index).build();
  }
  public CloudEventAttributes buildFirstCeAttribute() {
    return this.ceAttributes.get(0).build();
  }
  public CloudEventAttributes buildLastCeAttribute() {
    return this.ceAttributes.get(ceAttributes.size() - 1).build();
  }
  public CloudEventAttributes buildMatchingCeAttribute(Predicate<CloudEventAttributesBuilder> predicate) {
    for (CloudEventAttributesBuilder item: ceAttributes) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingCeAttribute(Predicate<CloudEventAttributesBuilder> predicate) {
    for (CloudEventAttributesBuilder item: ceAttributes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withCeAttributes(List<CloudEventAttributes> ceAttributes) {
    if (this.ceAttributes != null) { _visitables.get("ceAttributes").clear();}
    if (ceAttributes != null) {this.ceAttributes = new ArrayList(); for (CloudEventAttributes item : ceAttributes){this.addToCeAttributes(item);}} else { this.ceAttributes = null;} return (A) this;
  }
  public A withCeAttributes(io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventAttributes... ceAttributes) {
    if (this.ceAttributes != null) {this.ceAttributes.clear(); _visitables.remove("ceAttributes"); }
    if (ceAttributes != null) {for (CloudEventAttributes item :ceAttributes){ this.addToCeAttributes(item);}} return (A) this;
  }
  public boolean hasCeAttributes() {
    return ceAttributes != null && !ceAttributes.isEmpty();
  }
  public A addNewCeAttribute(String source,String type) {
    return (A)addToCeAttributes(new CloudEventAttributes(source, type));
  }
  public CeAttributesNested<A> addNewCeAttribute() {
    return new CeAttributesNested(-1, null);
  }
  public CeAttributesNested<A> addNewCeAttributeLike(CloudEventAttributes item) {
    return new CeAttributesNested(-1, item);
  }
  public CeAttributesNested<A> setNewCeAttributeLike(int index,CloudEventAttributes item) {
    return new CeAttributesNested(index, item);
  }
  public CeAttributesNested<A> editCeAttribute(int index) {
    if (ceAttributes.size() <= index) throw new RuntimeException("Can't edit ceAttributes. Index exceeds size.");
    return setNewCeAttributeLike(index, buildCeAttribute(index));
  }
  public CeAttributesNested<A> editFirstCeAttribute() {
    if (ceAttributes.size() == 0) throw new RuntimeException("Can't edit first ceAttributes. The list is empty.");
    return setNewCeAttributeLike(0, buildCeAttribute(0));
  }
  public CeAttributesNested<A> editLastCeAttribute() {
    int index = ceAttributes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last ceAttributes. The list is empty.");
    return setNewCeAttributeLike(index, buildCeAttribute(index));
  }
  public CeAttributesNested<A> editMatchingCeAttribute(Predicate<CloudEventAttributesBuilder> predicate) {
    int index = -1;
    for (int i=0;i<ceAttributes.size();i++) { 
    if (predicate.test(ceAttributes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching ceAttributes. No match found.");
    return setNewCeAttributeLike(index, buildCeAttribute(index));
  }
  public A addToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    ConditionBuilder builder = new ConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  public A setToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    ConditionBuilder builder = new ConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  public A addToConditions(io.fabric8.knative.internal.pkg.apis.Condition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<Condition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.knative.internal.pkg.apis.Condition... items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  public A removeAllFromConditions(Collection<Condition> items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<ConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      ConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<Condition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public Condition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  public Condition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public Condition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
    for (ConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
    for (ConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<Condition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").clear();}
    if (conditions != null) {this.conditions = new ArrayList(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.knative.internal.pkg.apis.Condition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public ConditionsNested<A> addNewCondition() {
    return new ConditionsNested(-1, null);
  }
  public ConditionsNested<A> addNewConditionLike(Condition item) {
    return new ConditionsNested(-1, item);
  }
  public ConditionsNested<A> setNewConditionLike(int index,Condition item) {
    return new ConditionsNested(index, item);
  }
  public ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration=observedGeneration; return (A) this;
  }
  public boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  public String getSinkCACerts() {
    return this.sinkCACerts;
  }
  public A withSinkCACerts(String sinkCACerts) {
    this.sinkCACerts=sinkCACerts; return (A) this;
  }
  public boolean hasSinkCACerts() {
    return this.sinkCACerts != null;
  }
  public String getSinkUri() {
    return this.sinkUri;
  }
  public A withSinkUri(String sinkUri) {
    this.sinkUri=sinkUri; return (A) this;
  }
  public boolean hasSinkUri() {
    return this.sinkUri != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PrometheusSourceStatusFluent that = (PrometheusSourceStatusFluent) o;
    if (!java.util.Objects.equals(annotations, that.annotations)) return false;

    if (!java.util.Objects.equals(ceAttributes, that.ceAttributes)) return false;

    if (!java.util.Objects.equals(conditions, that.conditions)) return false;

    if (!java.util.Objects.equals(observedGeneration, that.observedGeneration)) return false;

    if (!java.util.Objects.equals(sinkCACerts, that.sinkCACerts)) return false;

    if (!java.util.Objects.equals(sinkUri, that.sinkUri)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(annotations,  ceAttributes,  conditions,  observedGeneration,  sinkCACerts,  sinkUri,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (annotations != null && !annotations.isEmpty()) { sb.append("annotations:"); sb.append(annotations + ","); }
    if (ceAttributes != null && !ceAttributes.isEmpty()) { sb.append("ceAttributes:"); sb.append(ceAttributes + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration + ","); }
    if (sinkCACerts != null) { sb.append("sinkCACerts:"); sb.append(sinkCACerts + ","); }
    if (sinkUri != null) { sb.append("sinkUri:"); sb.append(sinkUri); }
    sb.append("}");
    return sb.toString();
  }
  public class CeAttributesNested<N> extends CloudEventAttributesFluent<CeAttributesNested<N>> implements Nested<N>{
    CeAttributesNested(int index,CloudEventAttributes item) {
      this.index = index;
      this.builder = new CloudEventAttributesBuilder(this, item);
    }
    CloudEventAttributesBuilder builder;
    int index;
    public N and() {
      return (N) PrometheusSourceStatusFluent.this.setToCeAttributes(index,builder.build());
    }
    public N endCeAttribute() {
      return and();
    }
    
  }
  public class ConditionsNested<N> extends ConditionFluent<ConditionsNested<N>> implements Nested<N>{
    ConditionsNested(int index,Condition item) {
      this.index = index;
      this.builder = new ConditionBuilder(this, item);
    }
    ConditionBuilder builder;
    int index;
    public N and() {
      return (N) PrometheusSourceStatusFluent.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  
}