package io.fabric8.knative.eventing.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TriggerSpecBuilder extends TriggerSpecFluent<TriggerSpecBuilder> implements VisitableBuilder<TriggerSpec,TriggerSpecBuilder>{
  public TriggerSpecBuilder() {
    this(false);
  }
  public TriggerSpecBuilder(Boolean validationEnabled) {
    this(new TriggerSpec(), validationEnabled);
  }
  public TriggerSpecBuilder(TriggerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public TriggerSpecBuilder(TriggerSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TriggerSpec(), validationEnabled);
  }
  public TriggerSpecBuilder(TriggerSpecFluent<?> fluent,TriggerSpec instance) {
    this(fluent, instance, false);
  }
  public TriggerSpecBuilder(TriggerSpecFluent<?> fluent,TriggerSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new TriggerSpec());

    if (instance != null) {
      fluent.withBroker(instance.getBroker());
      fluent.withDelivery(instance.getDelivery());
      fluent.withFilter(instance.getFilter());
      fluent.withFilters(instance.getFilters());
      fluent.withSubscriber(instance.getSubscriber());
      fluent.withBroker(instance.getBroker());
      fluent.withDelivery(instance.getDelivery());
      fluent.withFilter(instance.getFilter());
      fluent.withFilters(instance.getFilters());
      fluent.withSubscriber(instance.getSubscriber());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TriggerSpecBuilder(TriggerSpec instance) {
    this(instance,false);
  }
  public TriggerSpecBuilder(TriggerSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new TriggerSpec());

    if (instance != null) {
      this.withBroker(instance.getBroker());
      this.withDelivery(instance.getDelivery());
      this.withFilter(instance.getFilter());
      this.withFilters(instance.getFilters());
      this.withSubscriber(instance.getSubscriber());
      this.withBroker(instance.getBroker());
      this.withDelivery(instance.getDelivery());
      this.withFilter(instance.getFilter());
      this.withFilters(instance.getFilters());
      this.withSubscriber(instance.getSubscriber());
    }
    this.validationEnabled = validationEnabled; 
  }
  TriggerSpecFluent<?> fluent;
  Boolean validationEnabled;
  public TriggerSpec build() {
    TriggerSpec buildable = new TriggerSpec(fluent.getBroker(),fluent.buildDelivery(),fluent.buildFilter(),fluent.buildFilters(),fluent.buildSubscriber());
    return buildable;
  }
  
}