package io.fabric8.knative.eventing.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EventTypeSpecBuilder extends EventTypeSpecFluent<EventTypeSpecBuilder> implements VisitableBuilder<EventTypeSpec,EventTypeSpecBuilder>{
  public EventTypeSpecBuilder() {
    this(false);
  }
  public EventTypeSpecBuilder(Boolean validationEnabled) {
    this(new EventTypeSpec(), validationEnabled);
  }
  public EventTypeSpecBuilder(EventTypeSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public EventTypeSpecBuilder(EventTypeSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EventTypeSpec(), validationEnabled);
  }
  public EventTypeSpecBuilder(EventTypeSpecFluent<?> fluent,EventTypeSpec instance) {
    this(fluent, instance, false);
  }
  public EventTypeSpecBuilder(EventTypeSpecFluent<?> fluent,EventTypeSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new EventTypeSpec());

    if (instance != null) {
      fluent.withBroker(instance.getBroker());
      fluent.withDescription(instance.getDescription());
      fluent.withSchema(instance.getSchema());
      fluent.withSchemaData(instance.getSchemaData());
      fluent.withSource(instance.getSource());
      fluent.withType(instance.getType());
      fluent.withBroker(instance.getBroker());
      fluent.withDescription(instance.getDescription());
      fluent.withSchema(instance.getSchema());
      fluent.withSchemaData(instance.getSchemaData());
      fluent.withSource(instance.getSource());
      fluent.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EventTypeSpecBuilder(EventTypeSpec instance) {
    this(instance,false);
  }
  public EventTypeSpecBuilder(EventTypeSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new EventTypeSpec());

    if (instance != null) {
      this.withBroker(instance.getBroker());
      this.withDescription(instance.getDescription());
      this.withSchema(instance.getSchema());
      this.withSchemaData(instance.getSchemaData());
      this.withSource(instance.getSource());
      this.withType(instance.getType());
      this.withBroker(instance.getBroker());
      this.withDescription(instance.getDescription());
      this.withSchema(instance.getSchema());
      this.withSchemaData(instance.getSchemaData());
      this.withSource(instance.getSource());
      this.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  EventTypeSpecFluent<?> fluent;
  Boolean validationEnabled;
  public EventTypeSpec build() {
    EventTypeSpec buildable = new EventTypeSpec(fluent.getBroker(),fluent.getDescription(),fluent.getSchema(),fluent.getSchemaData(),fluent.getSource(),fluent.getType());
    return buildable;
  }
  
}