package io.fabric8.knative.flows.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ParallelBuilder extends ParallelFluent<ParallelBuilder> implements VisitableBuilder<Parallel,ParallelBuilder>{
  public ParallelBuilder() {
    this(false);
  }
  public ParallelBuilder(Boolean validationEnabled) {
    this(new Parallel(), validationEnabled);
  }
  public ParallelBuilder(ParallelFluent<?> fluent) {
    this(fluent, false);
  }
  public ParallelBuilder(ParallelFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Parallel(), validationEnabled);
  }
  public ParallelBuilder(ParallelFluent<?> fluent,Parallel instance) {
    this(fluent, instance, false);
  }
  public ParallelBuilder(ParallelFluent<?> fluent,Parallel instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Parallel());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ParallelBuilder(Parallel instance) {
    this(instance,false);
  }
  public ParallelBuilder(Parallel instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Parallel());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  ParallelFluent<?> fluent;
  Boolean validationEnabled;
  public Parallel build() {
    Parallel buildable = new Parallel(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}