package io.fabric8.knative.flows.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ParallelSubscriptionStatusBuilder extends ParallelSubscriptionStatusFluent<ParallelSubscriptionStatusBuilder> implements VisitableBuilder<ParallelSubscriptionStatus,ParallelSubscriptionStatusBuilder>{
  public ParallelSubscriptionStatusBuilder() {
    this(false);
  }
  public ParallelSubscriptionStatusBuilder(Boolean validationEnabled) {
    this(new ParallelSubscriptionStatus(), validationEnabled);
  }
  public ParallelSubscriptionStatusBuilder(ParallelSubscriptionStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ParallelSubscriptionStatusBuilder(ParallelSubscriptionStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ParallelSubscriptionStatus(), validationEnabled);
  }
  public ParallelSubscriptionStatusBuilder(ParallelSubscriptionStatusFluent<?> fluent,ParallelSubscriptionStatus instance) {
    this(fluent, instance, false);
  }
  public ParallelSubscriptionStatusBuilder(ParallelSubscriptionStatusFluent<?> fluent,ParallelSubscriptionStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ParallelSubscriptionStatus());

    if (instance != null) {
      fluent.withReady(instance.getReady());
      fluent.withSubscription(instance.getSubscription());
      fluent.withReady(instance.getReady());
      fluent.withSubscription(instance.getSubscription());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ParallelSubscriptionStatusBuilder(ParallelSubscriptionStatus instance) {
    this(instance,false);
  }
  public ParallelSubscriptionStatusBuilder(ParallelSubscriptionStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ParallelSubscriptionStatus());

    if (instance != null) {
      this.withReady(instance.getReady());
      this.withSubscription(instance.getSubscription());
      this.withReady(instance.getReady());
      this.withSubscription(instance.getSubscription());
    }
    this.validationEnabled = validationEnabled; 
  }
  ParallelSubscriptionStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ParallelSubscriptionStatus build() {
    ParallelSubscriptionStatus buildable = new ParallelSubscriptionStatus(fluent.buildReady(),fluent.buildSubscription());
    return buildable;
  }
  
}