package io.fabric8.knative.flows.v1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.knative.messaging.v1.ChannelTemplateSpec;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.knative.messaging.v1.ChannelTemplateSpecBuilder;
import io.fabric8.knative.messaging.v1.ChannelTemplateSpecFluent;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class SequenceSpecFluent<A extends SequenceSpecFluent<A>> extends BaseFluent<A>{
  public SequenceSpecFluent() {
  }
  public SequenceSpecFluent(SequenceSpec instance) {
    instance = (instance != null ? instance : new SequenceSpec());

    if (instance != null) {
      this.withChannelTemplate(instance.getChannelTemplate());
      this.withReply(instance.getReply());
      this.withSteps(instance.getSteps());
      this.withChannelTemplate(instance.getChannelTemplate());
      this.withReply(instance.getReply());
      this.withSteps(instance.getSteps());
    }
  }
  private ChannelTemplateSpecBuilder channelTemplate;
  private DestinationBuilder reply;
  private ArrayList<SequenceStepBuilder> steps = new ArrayList<SequenceStepBuilder>();
  public ChannelTemplateSpec buildChannelTemplate() {
    return this.channelTemplate!=null ?this.channelTemplate.build():null;
  }
  public A withChannelTemplate(ChannelTemplateSpec channelTemplate) {
    _visitables.get("channelTemplate").remove(this.channelTemplate);
    if (channelTemplate!=null){ this.channelTemplate= new ChannelTemplateSpecBuilder(channelTemplate); _visitables.get("channelTemplate").add(this.channelTemplate);} else { this.channelTemplate = null; _visitables.get("channelTemplate").remove(this.channelTemplate); } return (A) this;
  }
  public boolean hasChannelTemplate() {
    return this.channelTemplate != null;
  }
  public ChannelTemplateNested<A> withNewChannelTemplate() {
    return new ChannelTemplateNested(null);
  }
  public ChannelTemplateNested<A> withNewChannelTemplateLike(ChannelTemplateSpec item) {
    return new ChannelTemplateNested(item);
  }
  public ChannelTemplateNested<A> editChannelTemplate() {
    return withNewChannelTemplateLike(java.util.Optional.ofNullable(buildChannelTemplate()).orElse(null));
  }
  public ChannelTemplateNested<A> editOrNewChannelTemplate() {
    return withNewChannelTemplateLike(java.util.Optional.ofNullable(buildChannelTemplate()).orElse(new ChannelTemplateSpecBuilder().build()));
  }
  public ChannelTemplateNested<A> editOrNewChannelTemplateLike(ChannelTemplateSpec item) {
    return withNewChannelTemplateLike(java.util.Optional.ofNullable(buildChannelTemplate()).orElse(item));
  }
  public Destination buildReply() {
    return this.reply!=null ?this.reply.build():null;
  }
  public A withReply(Destination reply) {
    _visitables.get("reply").remove(this.reply);
    if (reply!=null){ this.reply= new DestinationBuilder(reply); _visitables.get("reply").add(this.reply);} else { this.reply = null; _visitables.get("reply").remove(this.reply); } return (A) this;
  }
  public boolean hasReply() {
    return this.reply != null;
  }
  public ReplyNested<A> withNewReply() {
    return new ReplyNested(null);
  }
  public ReplyNested<A> withNewReplyLike(Destination item) {
    return new ReplyNested(item);
  }
  public ReplyNested<A> editReply() {
    return withNewReplyLike(java.util.Optional.ofNullable(buildReply()).orElse(null));
  }
  public ReplyNested<A> editOrNewReply() {
    return withNewReplyLike(java.util.Optional.ofNullable(buildReply()).orElse(new DestinationBuilder().build()));
  }
  public ReplyNested<A> editOrNewReplyLike(Destination item) {
    return withNewReplyLike(java.util.Optional.ofNullable(buildReply()).orElse(item));
  }
  public A addToSteps(int index,SequenceStep item) {
    if (this.steps == null) {this.steps = new ArrayList<SequenceStepBuilder>();}
    SequenceStepBuilder builder = new SequenceStepBuilder(item);
    if (index < 0 || index >= steps.size()) { _visitables.get("steps").add(builder); steps.add(builder); } else { _visitables.get("steps").add(index, builder); steps.add(index, builder);}
    return (A)this;
  }
  public A setToSteps(int index,SequenceStep item) {
    if (this.steps == null) {this.steps = new ArrayList<SequenceStepBuilder>();}
    SequenceStepBuilder builder = new SequenceStepBuilder(item);
    if (index < 0 || index >= steps.size()) { _visitables.get("steps").add(builder); steps.add(builder); } else { _visitables.get("steps").set(index, builder); steps.set(index, builder);}
    return (A)this;
  }
  public A addToSteps(io.fabric8.knative.flows.v1.SequenceStep... items) {
    if (this.steps == null) {this.steps = new ArrayList<SequenceStepBuilder>();}
    for (SequenceStep item : items) {SequenceStepBuilder builder = new SequenceStepBuilder(item);_visitables.get("steps").add(builder);this.steps.add(builder);} return (A)this;
  }
  public A addAllToSteps(Collection<SequenceStep> items) {
    if (this.steps == null) {this.steps = new ArrayList<SequenceStepBuilder>();}
    for (SequenceStep item : items) {SequenceStepBuilder builder = new SequenceStepBuilder(item);_visitables.get("steps").add(builder);this.steps.add(builder);} return (A)this;
  }
  public A removeFromSteps(io.fabric8.knative.flows.v1.SequenceStep... items) {
    if (this.steps == null) return (A)this;
    for (SequenceStep item : items) {SequenceStepBuilder builder = new SequenceStepBuilder(item);_visitables.get("steps").remove(builder); this.steps.remove(builder);} return (A)this;
  }
  public A removeAllFromSteps(Collection<SequenceStep> items) {
    if (this.steps == null) return (A)this;
    for (SequenceStep item : items) {SequenceStepBuilder builder = new SequenceStepBuilder(item);_visitables.get("steps").remove(builder); this.steps.remove(builder);} return (A)this;
  }
  public A removeMatchingFromSteps(Predicate<SequenceStepBuilder> predicate) {
    if (steps == null) return (A) this;
    final Iterator<SequenceStepBuilder> each = steps.iterator();
    final List visitables = _visitables.get("steps");
    while (each.hasNext()) {
      SequenceStepBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<SequenceStep> buildSteps() {
    return steps != null ? build(steps) : null;
  }
  public SequenceStep buildStep(int index) {
    return this.steps.get(index).build();
  }
  public SequenceStep buildFirstStep() {
    return this.steps.get(0).build();
  }
  public SequenceStep buildLastStep() {
    return this.steps.get(steps.size() - 1).build();
  }
  public SequenceStep buildMatchingStep(Predicate<SequenceStepBuilder> predicate) {
    for (SequenceStepBuilder item: steps) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingStep(Predicate<SequenceStepBuilder> predicate) {
    for (SequenceStepBuilder item: steps) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSteps(List<SequenceStep> steps) {
    if (this.steps != null) { _visitables.get("steps").clear();}
    if (steps != null) {this.steps = new ArrayList(); for (SequenceStep item : steps){this.addToSteps(item);}} else { this.steps = null;} return (A) this;
  }
  public A withSteps(io.fabric8.knative.flows.v1.SequenceStep... steps) {
    if (this.steps != null) {this.steps.clear(); _visitables.remove("steps"); }
    if (steps != null) {for (SequenceStep item :steps){ this.addToSteps(item);}} return (A) this;
  }
  public boolean hasSteps() {
    return steps != null && !steps.isEmpty();
  }
  public StepsNested<A> addNewStep() {
    return new StepsNested(-1, null);
  }
  public StepsNested<A> addNewStepLike(SequenceStep item) {
    return new StepsNested(-1, item);
  }
  public StepsNested<A> setNewStepLike(int index,SequenceStep item) {
    return new StepsNested(index, item);
  }
  public StepsNested<A> editStep(int index) {
    if (steps.size() <= index) throw new RuntimeException("Can't edit steps. Index exceeds size.");
    return setNewStepLike(index, buildStep(index));
  }
  public StepsNested<A> editFirstStep() {
    if (steps.size() == 0) throw new RuntimeException("Can't edit first steps. The list is empty.");
    return setNewStepLike(0, buildStep(0));
  }
  public StepsNested<A> editLastStep() {
    int index = steps.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last steps. The list is empty.");
    return setNewStepLike(index, buildStep(index));
  }
  public StepsNested<A> editMatchingStep(Predicate<SequenceStepBuilder> predicate) {
    int index = -1;
    for (int i=0;i<steps.size();i++) { 
    if (predicate.test(steps.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching steps. No match found.");
    return setNewStepLike(index, buildStep(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SequenceSpecFluent that = (SequenceSpecFluent) o;
    if (!java.util.Objects.equals(channelTemplate, that.channelTemplate)) return false;

    if (!java.util.Objects.equals(reply, that.reply)) return false;

    if (!java.util.Objects.equals(steps, that.steps)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(channelTemplate,  reply,  steps,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (channelTemplate != null) { sb.append("channelTemplate:"); sb.append(channelTemplate + ","); }
    if (reply != null) { sb.append("reply:"); sb.append(reply + ","); }
    if (steps != null && !steps.isEmpty()) { sb.append("steps:"); sb.append(steps); }
    sb.append("}");
    return sb.toString();
  }
  public class ChannelTemplateNested<N> extends ChannelTemplateSpecFluent<ChannelTemplateNested<N>> implements Nested<N>{
    ChannelTemplateNested(ChannelTemplateSpec item) {
      this.builder = new ChannelTemplateSpecBuilder(this, item);
    }
    ChannelTemplateSpecBuilder builder;
    public N and() {
      return (N) SequenceSpecFluent.this.withChannelTemplate(builder.build());
    }
    public N endChannelTemplate() {
      return and();
    }
    
  }
  public class ReplyNested<N> extends DestinationFluent<ReplyNested<N>> implements Nested<N>{
    ReplyNested(Destination item) {
      this.builder = new DestinationBuilder(this, item);
    }
    DestinationBuilder builder;
    public N and() {
      return (N) SequenceSpecFluent.this.withReply(builder.build());
    }
    public N endReply() {
      return and();
    }
    
  }
  public class StepsNested<N> extends SequenceStepFluent<StepsNested<N>> implements Nested<N>{
    StepsNested(int index,SequenceStep item) {
      this.index = index;
      this.builder = new SequenceStepBuilder(this, item);
    }
    SequenceStepBuilder builder;
    int index;
    public N and() {
      return (N) SequenceSpecFluent.this.setToSteps(index,builder.build());
    }
    public N endStep() {
      return and();
    }
    
  }
  
}