package io.fabric8.knative.flows.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SequenceStepBuilder extends SequenceStepFluent<SequenceStepBuilder> implements VisitableBuilder<SequenceStep,SequenceStepBuilder>{
  public SequenceStepBuilder() {
    this(false);
  }
  public SequenceStepBuilder(Boolean validationEnabled) {
    this(new SequenceStep(), validationEnabled);
  }
  public SequenceStepBuilder(SequenceStepFluent<?> fluent) {
    this(fluent, false);
  }
  public SequenceStepBuilder(SequenceStepFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SequenceStep(), validationEnabled);
  }
  public SequenceStepBuilder(SequenceStepFluent<?> fluent,SequenceStep instance) {
    this(fluent, instance, false);
  }
  public SequenceStepBuilder(SequenceStepFluent<?> fluent,SequenceStep instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SequenceStep());

    if (instance != null) {
      fluent.withCACerts(instance.getCACerts());
      fluent.withDelivery(instance.getDelivery());
      fluent.withRef(instance.getRef());
      fluent.withUri(instance.getUri());
      fluent.withCACerts(instance.getCACerts());
      fluent.withDelivery(instance.getDelivery());
      fluent.withRef(instance.getRef());
      fluent.withUri(instance.getUri());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SequenceStepBuilder(SequenceStep instance) {
    this(instance,false);
  }
  public SequenceStepBuilder(SequenceStep instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SequenceStep());

    if (instance != null) {
      this.withCACerts(instance.getCACerts());
      this.withDelivery(instance.getDelivery());
      this.withRef(instance.getRef());
      this.withUri(instance.getUri());
      this.withCACerts(instance.getCACerts());
      this.withDelivery(instance.getDelivery());
      this.withRef(instance.getRef());
      this.withUri(instance.getUri());
    }
    this.validationEnabled = validationEnabled; 
  }
  SequenceStepFluent<?> fluent;
  Boolean validationEnabled;
  public SequenceStep build() {
    SequenceStep buildable = new SequenceStep(fluent.getCACerts(),fluent.buildDelivery(),fluent.buildRef(),fluent.getUri());
    return buildable;
  }
  
}