package io.fabric8.knative.internal.autoscaling.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MetricBuilder extends MetricFluent<MetricBuilder> implements VisitableBuilder<Metric,MetricBuilder>{
  public MetricBuilder() {
    this(false);
  }
  public MetricBuilder(Boolean validationEnabled) {
    this(new Metric(), validationEnabled);
  }
  public MetricBuilder(MetricFluent<?> fluent) {
    this(fluent, false);
  }
  public MetricBuilder(MetricFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Metric(), validationEnabled);
  }
  public MetricBuilder(MetricFluent<?> fluent,Metric instance) {
    this(fluent, instance, false);
  }
  public MetricBuilder(MetricFluent<?> fluent,Metric instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Metric());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MetricBuilder(Metric instance) {
    this(instance,false);
  }
  public MetricBuilder(Metric instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Metric());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  MetricFluent<?> fluent;
  Boolean validationEnabled;
  public Metric build() {
    Metric buildable = new Metric(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}