package io.fabric8.knative.internal.autoscaling.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MetricStatusBuilder extends MetricStatusFluent<MetricStatusBuilder> implements VisitableBuilder<MetricStatus,MetricStatusBuilder>{
  public MetricStatusBuilder() {
    this(false);
  }
  public MetricStatusBuilder(Boolean validationEnabled) {
    this(new MetricStatus(), validationEnabled);
  }
  public MetricStatusBuilder(MetricStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public MetricStatusBuilder(MetricStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MetricStatus(), validationEnabled);
  }
  public MetricStatusBuilder(MetricStatusFluent<?> fluent,MetricStatus instance) {
    this(fluent, instance, false);
  }
  public MetricStatusBuilder(MetricStatusFluent<?> fluent,MetricStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new MetricStatus());

    if (instance != null) {
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MetricStatusBuilder(MetricStatus instance) {
    this(instance,false);
  }
  public MetricStatusBuilder(MetricStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new MetricStatus());

    if (instance != null) {
      this.withAnnotations(instance.getAnnotations());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withAnnotations(instance.getAnnotations());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  MetricStatusFluent<?> fluent;
  Boolean validationEnabled;
  public MetricStatus build() {
    MetricStatus buildable = new MetricStatus(fluent.getAnnotations(),fluent.buildConditions(),fluent.getObservedGeneration());
    return buildable;
  }
  
}