package io.fabric8.knative.internal.caching.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageSpecBuilder extends ImageSpecFluent<ImageSpecBuilder> implements VisitableBuilder<ImageSpec,ImageSpecBuilder>{
  public ImageSpecBuilder() {
    this(false);
  }
  public ImageSpecBuilder(Boolean validationEnabled) {
    this(new ImageSpec(), validationEnabled);
  }
  public ImageSpecBuilder(ImageSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageSpecBuilder(ImageSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageSpec(), validationEnabled);
  }
  public ImageSpecBuilder(ImageSpecFluent<?> fluent,ImageSpec instance) {
    this(fluent, instance, false);
  }
  public ImageSpecBuilder(ImageSpecFluent<?> fluent,ImageSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ImageSpec());

    if (instance != null) {
      fluent.withImage(instance.getImage());
      fluent.withImagePullSecrets(instance.getImagePullSecrets());
      fluent.withServiceAccountName(instance.getServiceAccountName());
      fluent.withImage(instance.getImage());
      fluent.withImagePullSecrets(instance.getImagePullSecrets());
      fluent.withServiceAccountName(instance.getServiceAccountName());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImageSpecBuilder(ImageSpec instance) {
    this(instance,false);
  }
  public ImageSpecBuilder(ImageSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ImageSpec());

    if (instance != null) {
      this.withImage(instance.getImage());
      this.withImagePullSecrets(instance.getImagePullSecrets());
      this.withServiceAccountName(instance.getServiceAccountName());
      this.withImage(instance.getImage());
      this.withImagePullSecrets(instance.getImagePullSecrets());
      this.withServiceAccountName(instance.getServiceAccountName());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImageSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ImageSpec build() {
    ImageSpec buildable = new ImageSpec(fluent.getImage(),fluent.buildImagePullSecrets(),fluent.getServiceAccountName());
    return buildable;
  }
  
}